% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_resource.R
\name{update_resource}
\alias{update_resource}
\title{Update Resources}
\usage{
update_resource(
  resource,
  id = NULL,
  path = NULL,
  body = NULL,
  token = NULL,
  on.error = c("stop", "warn", "message"),
  verbose = FALSE,
  handle = NULL,
  encode,
  response
)
}
\arguments{
\item{resource}{Model name, eg. \code{"card"}.}

\item{id}{Model id.}

\item{path}{Path.}

\item{body}{A named list.}

\item{token}{An object of class \code{"Trello_API_token"}, a path or \code{NULL}.
\itemize{
\item If a \code{Token}, it is passed as is.
\item If \code{NULL} and a cache file called \code{".httr-oauth"} exists, the newest token
is read from it. If the file is not found, an error is thrown.
\item If a character vector of length 1, it will be used as an alternative path
to the cache file.
}}

\item{on.error}{Behavior when HTTP status >= 300, defaults to \code{"stop"}.}

\item{verbose}{Whether to pass \code{\link[httr:verbose]{httr::verbose()}} to \code{\link[httr:RETRY]{httr::RETRY()}}.}

\item{handle}{Passed to \code{\link[httr:RETRY]{httr::RETRY()}}.}

\item{encode, response}{Deprecated.}
}
\description{
Update resources via Trello API.
}
\details{
See \href{https://developers.trello.com/v1.0/reference}{Trello API reference}
for more info about what elements can be included in PUT request body.
}
\examples{

\dontrun{

# Get token with write access
key = Sys.getenv("MY_TRELLO_KEY")
secret = Sys.getenv("MY_TRELLO_SECRET")

token = get_token("my_app", key = key, secret = secret,
                  scope = c("read", "write"))

# Get board ID
url = "Your board URL"
bid = get_id_board(url, token)

# Get cards and extract ID of the first one
cid = get_board_cards(bid, token)$id[1]

# Content for the new card
payload = list(
  id = cid,
  name = "A new card name",
  desc = "Description - updated by trelloR",
  pos = "top" #put card on the top of a list
)

# Update card's name, descriptionand position
update_resource("card", id = cid, body = payload, token = token)
}
}
