% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_batch.R
\name{get_batch}
\alias{get_batch}
\title{Dispatch a Batch Request}
\usage{
get_batch(
  parent,
  child,
  ids,
  token = NULL,
  query = NULL,
  on.error = c("stop", "warn", "message"),
  retry.times = 1,
  handle = NULL,
  verbose = FALSE
)
}
\arguments{
\item{parent}{Parent resource, e.g. \code{"board"}.}

\item{child}{Child resource, eg. \code{"card"}.}

\item{ids}{A vector of resource IDs, with maximum length of 10.}

\item{token}{An object of class \code{"Trello_API_token"}, a path or \code{NULL}.
\itemize{
\item If a \code{Token}, it is passed as is.
\item If \code{NULL} and a cache file called \code{".httr-oauth"} exists, the newest token
is read from it. If the file is not found, an error is thrown.
\item If a character vector of length 1, it will be used as an alternative path
to the cache file.
}}

\item{query}{Named list of key-value pairs, appended to each component
of the batch request. See \code{\link[httr:GET]{httr::GET()}} for details. NOTE: If you require
different query with each batch component, build the list of URLs
yourself using \code{\link[=get_resource]{get_resource()}}, as per \href{https://developer.atlassian.com/cloud/trello/rest/api-group-batch/#api-group-batch}{Trello API reference}.}

\item{on.error}{Whether to \code{"stop"}, \code{"warn"} or \code{"message"} on API error.}

\item{retry.times}{How many times to re-try when a request fails. Defaults
to 1.}

\item{handle}{The handle to use with this request, see \code{\link[httr:RETRY]{httr::RETRY()}}.}

\item{verbose}{Set to \code{TRUE} for verbose output.}
}
\value{
A data frame (or a tibble, if installed).
}
\description{
Perform 1 to 10 GET requests at once.
}
\examples{

demo_board <- "https://trello.com/b/wVWPK9I4/r-client-for-the-trello-api"

if (FALSE) {
# Download custom field values for 10 cards.
cards <- get_board_cards(demo_board, limit = 10)
values <- get_batch(
  parent = "card",
  child = "customFieldItems",
  ids = cards$id
)
values
}
}
\seealso{
\code{\link[=get_token]{get_token()}}, \code{\link[=get_id]{get_id()}}, \code{\link[httr:GET]{httr::GET()}}, \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}}
}
