% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mk.test.R
\name{mk.test}
\alias{mk.test}
\title{Mann-Kendall Trend Test}
\usage{
mk.test(x, alternative = c("two.sided", "greater", "less"), continuity = TRUE)
}
\arguments{
\item{x}{a vector of class "numeric" or a time series object of class "ts"}

\item{alternative}{the alternative hypothesis, defaults to \code{two.sided}}

\item{continuity}{logical, indicates whether a continuity correction
should be applied, defaults to \code{TRUE}.}
}
\value{
A list with class "htest"
\item{data.name}{character string that denotes the input data}
\item{p.value}{the p-value}
\item{statistic}{the z quantile of the standard normal distribution}
\item{null.value}{the null hypothesis}
\item{estimates}{the estimates S, varS and tau}
\item{alternative}{the alternative hypothesis}
\item{method}{character string that denotes the test}
}
\description{
Performs the Mann-Kendall Trend Test
}
\details{
The null hypothesis is that the data come from a population with
independent realizations and are identically distributed.
For the two sided test, the alternative hypothesis
is that the data follow a monotonic trend. The Mann-Kendall test
statistic is calculated according to:

\deqn{
S = \sum_{k = 1}^{n-1} \sum_{j = k + 1}^n
\mathrm{sgn}\left(x_j - x_k\right)}{%
S = \sum_{k = 1}^{n-1} \sum_{j = k + 1}^n
sgn(x[j] - x[k])}

with \eqn{\mathrm{sgn}}{sgn} the signum function (see \code{\link{sign}}).

The mean of \eqn{S} is \eqn{\mu = 0}. The variance including the
correction term for ties is

\deqn{
\sigma^2 = \left\{n \left(n-1\right)\left(2n+5\right) -
\sum_{j=1}^p t_j\left(t_j - 1\right)\left(2t_j+5\right) \right\} / 18}

where \eqn{p} is the number of the tied groups in the data set and
\eqn{t_j} is the number of data points in the \eqn{j}-th tied group.
The statistic \eqn{S} is approximately normally distributed, with

\deqn{z = S / \sigma} 

If \code{continuity = TRUE} then a continuity correction will be employed:

\deqn{z = \mathrm{sgn}(S) ~ \left(|S| - 1\right) / \sigma}{%
  z = sgn(S) * (|S| -1) / \sigma}

The statistic \eqn{S} is closely related to Kendall's \eqn{\tau}:
\deqn{\tau = S / D}

where

\deqn{
D = \left[\frac{1}{2}n\left(n-1\right)-
     \frac{1}{2}\sum_{j=1}^p t_j\left(t_j - 1\right)\right]^{1/2}
    \left[\frac{1}{2}n\left(n-1\right) \right]^{1/2}
}
}
\note{
Current Version is for complete observations only.
}
\examples{
data(Nile)
mk.test(Nile, continuity = TRUE)

##
n <- length(Nile)
cor.test(x=(1:n),y=Nile, meth="kendall", continuity = TRUE)

}
\references{
Hipel, K.W. and McLeod, A.I. (1994),
\emph{Time Series Modelling of Water Resources and Environmental Systems}. 
New York: Elsevier Science.

Libiseller, C. and Grimvall, A., (2002), Performance of partial
Mann-Kendall tests for trend detection in the presence of covariates.
\emph{Environmetrics} 13, 71--84, \doi{10.1002/env.507}.
}
\seealso{
\code{\link{cor.test}},
\code{\link[Kendall]{MannKendall}},
\code{\link{partial.mk.test}},
\code{\link{sens.slope}}
}
\keyword{nonparametric}
\keyword{ts}
\keyword{univar}
