% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-interface.R
\name{trending_model}
\alias{trending_model}
\alias{trending_models}
\alias{glm_model}
\alias{glm_nb_model}
\alias{lm_model}
\alias{brms_model}
\title{Modeling interface}
\usage{
glm_model(formula, family, ...)

glm_nb_model(formula, ...)

lm_model(formula, ...)

brms_model(formula, family, ...)
}
\arguments{
\item{formula}{The formula of the model, with the response variable on the
left of a tilde symbol, and predictors on the right hand-side; variable
names used in the formula will need to be matched by columns in the \code{data}
input to other functions.}

\item{family}{The model family to be used for the response variable.}

\item{...}{Further arguments passed underlying models: \code{lm} for \code{\link[=lm_model]{lm_model()}},
\code{glm} for \code{\link[=glm_model]{glm_model()}}, \code{\link[MASS:glm.nb]{MASS::glm.nb()}} for \code{glm_nb_model}, \code{\link[brms:brm]{brms::brm()}}
for \code{brms_model}.  Not used for \code{print} and \code{format}.}
}
\value{
A \code{trending_model} object (S3 class inheriting \code{list}), containing
items which can be accessed by various accessors - see
\code{?trending_model-accessors}.
}
\description{
These functions wrappers around various modelling tools to ensure a
consistent input for \emph{trending} functions. See details for available model
interfaces.
}
\details{
The following interfaces are available:
\itemize{
\item \code{lm_model}: interface for linear models implemented in
\code{\link[stats:lm]{stats::lm()}}.
\item \code{glm_model}: interface for generalised linear models (GLMs) implemented in
\code{\link[stats:glm]{stats::glm()}}.
\item \code{glm_nb_model}: interface for negative binomial generalied linear models
implemented in \link[MASS:glm.nb]{MASS::glm.nb}.
\item \code{brms_model}: interface for Bayesian regression models implemented in
\link[brms:brm]{brms::brm}.
}
}
\examples{
x = rnorm(100, mean = 0)
y = rpois(n = 100, lambda = exp(1.5 + 0.5*x))

poisson_model <- glm_model(y ~ x , family = "poisson")
negbin_model <- glm_nb_model(y ~ x)

}
\author{
Dirk Schumacher
}
