% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter}
\alias{filter}
\title{Finding a detail filter vector for computing a detail coefficient}
\usage{
filter(a)
}
\arguments{
\item{a}{A vector with length 6. First three elements contain a triplet selected from the weight vector of constancy and the last three elements correspond to a selected triplet of the weight vector of linearity.}
}
\value{
\item{df}{The detail filter vector of length 3 which is used as a weight vector for the corresponding triplet of smooth coefficients.}
}
\description{
This function is used inside \code{\link{TGUW}} function but is typically not called directly by the user. This returns a vector of detail filter, a weight vector of the triplet of smooth coefficients where the corresponding detail coefficient is obtained as a weighted sum of three smooth coefficients.
}
\details{
The detail filter is obtained in such a way to produce zero detail coefficient only when the corresponding (raw) observations in merging regions have a perfect linear trend, as the detail coefficient itself represents the extent of non-linearity in the corresponding region of data. This implies that the smaller the size of the detail coefficient, the closer the alignment of the corresponding data section with linearity. For details, see H. Maeng and P. Fryzlewicz (2019), Detecting linear trend changes and point anomalies in data sequences, preprint.
}
\examples{
x <- c(rep(1, 3), 1:3)
filter(x)

y <- c(rep(1, 3), 4:6)
filter(y) # same as filter(x)
}
\seealso{
\code{\link{TGUW}}
}
\author{
Hyeyoung Maeng, \email{h.maeng@lse.ac.uk}
}
