% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invTGUW.R
\name{invTGUW}
\alias{invTGUW}
\title{Inverse Tail-Greedy Unbalanced Wavelet (TGUW) transformation}
\usage{
invTGUW(ts.obj)
}
\arguments{
\item{ts.obj}{A list returned by \code{thresholding}.}
}
\value{
\item{ts.obj}{The modified ts.obj is the result of the inverse TGUW transformation and \code{ts.coeffs} now presents the estimated piecewise-linear signal of the data.}
}
\description{
This function is used inside \code{\link{trendsegment}} and performs the inverse TGUW transformation by undoing the orthonormal transformation of \code{TGUW} in reverse order.
Details of the inverse TGUW transformation can be found in H. Maeng and P. Fryzlewicz (2021), Detecting linear trend changes in data sequences, preprint.
}
\examples{
x <- c(1:10, rep(5,9))
n <- length(x)
x <- x + rnorm(n)
tguwfit <- TGUW(x)
th.const <- 1.3
lambda <- (stats::mad(diff(diff(x)))/sqrt(6)) * sqrt(2 * log(n)) * th.const
thrfit <- thresholding(ts.obj = tguwfit, lambda = lambda, minsegL = 5, bal = 0, connected = TRUE)
invfit <- invTGUW(ts.obj = thrfit)
invfit
}
\seealso{
\code{\link{trendsegment}}, \code{\link{TGUW}}, \code{\link{thresholding}}
}
\author{
Hyeyoung Maeng \email{h.maeng4@lancaster.ac.uk}, Piotr Fryzlewicz \email{p.fryzlewicz@lse.ac.uk}
}
