% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms.R
\name{sepIdGaps}
\alias{sepIdGaps}
\title{Separate a set of IDs based on gaps}
\usage{
sepIdGaps(id, gapdata, minGap = 3600 * 24 * 7)
}
\arguments{
\item{id}{existing ID levels}

\item{gapdata}{data matching \code{id} with gaps to use as separators}

\item{minGap}{the minimum "gap" to use in gapdata to create a new ID level}
}
\value{
A new set of ID levels, named following the pattern that "ID" split into 3
would provided "ID", "ID\_2" and "ID\_3".
}
\description{
A new set of ID levels can be created by separating those given based on a
minimum gap in another set of data. This is useful for separating
instruments identified only by their ID into separate events in time.
}
\details{
The assumption is that a week is a long time for a tag not to record
anything.
}
\section{Warning}{


It is assumed that each vector provides is sorted by \code{gapdata} within
\code{id}. No checking is done, and so it is suggested that this only be
used on ID columns within existing, validated \code{trip} objects.
}

\examples{


id <- gl(2, 8)
gd <- Sys.time() + 1:16
gd[c(4:6, 12:16)] <- gd[c(4:6, 12:16)] + 10000
sepIdGaps(id, gd, 1000)


}
\seealso{
\code{\link{trip}}
}
\keyword{manip}
