% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aspect_importance.R
\name{print.aspect_importance}
\alias{print.aspect_importance}
\title{Function for printing aspect_importance results}
\usage{
\method{print}{aspect_importance}(x, show_features = FALSE, show_corr = FALSE, ...)
}
\arguments{
\item{x}{object of aspect_importance class}

\item{show_features}{show list of features for every aspect}

\item{show_corr}{show if all features in aspect are pairwise positively
correlated (for numeric features only)}

\item{...}{other parameters}
}
\description{
This function prints the results of aspect_importance.
}
\examples{
library("DALEX")

model_titanic_glm <- glm(survived == 1 ~
                         class+gender+age+sibsp+parch+fare+embarked,
                         data = titanic_imputed,
                         family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed[,-8],
                               y = titanic_imputed$survived == 1,
                               verbose = FALSE)

aspects <- list(wealth = c("class", "fare"),
                family = c("sibsp", "parch"),
                personal = c("gender", "age"),
                embarked = "embarked")

titanic_ai <- predict_aspects(explain_titanic_glm,
                  new_observation = titanic_imputed[1,],
                  variable_groups = aspects)
print(titanic_ai)

}
