% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{truth_trajectory_models}
\alias{truth_trajectory_models}
\title{Fitted Models from the Longitudinal Illusory Truth Study}
\format{
This object is a named list with six elements, with each
  element representing a fitted model object of class "clmm",
  resulting from a call to the \code{\link[ordinal]{clmm}}
  function. The named elements are:

\describe{

  \item{\code{main_base}}{Base model for testing the main effect; 
  model formula is \code{mod1 <- T ~ R + I1 + I2 + I3 + R:I1 + R:I2 + R:I3 + (R | subj_id) + (R | stim_id)}.}

  \item{\code{main_comp}}{Comparison model for testing the main
    effect; model formula identical to \code{main_base} except the
    fixed effect \code{R} has been excluded.}

  \item{\code{ix_base}}{Base model for testing the
    repetition-by-interval interaction; Model formula is \code{mod3
    <- T ~ R + I1 + I2 + I3 + R:I1 + R:I2 + R:I3 + (R:I1 + R:I2 +
    R:I3 | subj_id) + (R:I1 + R:I2 + R:I3 | stim_id)}.}

  \item{\code{ix_comp}}{Comparison model for testing the
  interaction; Model formula is identical to \code{ix_base} except
  for exclusion of the fixed effects terms \code{R:I1},
  \code{R:I2}, and \code{R:I3}.}

  \item{\code{ix2}}{Same as \code{ix_base} except predictors
  included as factors rather than numerical predictors to enable
  use of functions from the \code{emmeans} package (for equivalence
  and follow-up tests).}

  \item{\code{main2}}{Same as \code{main_base} except predictors
  included as factors rather than numerical predictors to enable
  use of functions from the \code{emmeans} package (for equivalence
  and follow-up tests).}
}
}
\usage{
truth_trajectory_models
}
\description{
Fitted models from the pre-registered analysis of
  \insertCite{Henderson_Simons_Barr_2021;textual}{truthiness},
  which have been stored as an objects in the package because the
  fitting process is too slow to allow them to be re-created when
  needed.
}
\examples{
library(ordinal)

## print model information
summary(truth_trajectory_models$ix_base)

## likelihood ratio test, testing repetition-by-interval interaction
anova(truth_trajectory_models$ix_base,
      truth_trajectory_models$ix_comp)
}
\keyword{datasets}
