% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{dataset_sincos_generate}
\alias{dataset_sincos_generate}
\title{Sin-Cos data set generator. This function generates a set of sine and cosine
time series. This function is used as example of the package application.}
\usage{
dataset_sincos_generate(
  num_sin_series = 25,
  num_cos_series = 25,
  x_max = 8 * pi,
  ts_length = 100,
  jitter_amount = 0.1,
  return_x_values = FALSE
)
}
\arguments{
\item{num_sin_series}{Integer. Number of sine time series}

\item{num_cos_series}{Integer. Number of cosine time series}

\item{x_max}{Float. Max x value in sin(x) or cor(x).}

\item{ts_length}{Integer. Time series length.}

\item{jitter_amount}{Float. The total amount of jitter added to each time series.}

\item{return_x_values}{Boolean. If positive, returns a list of
data frames with x and y values.}
}
\value{
A list with all time series. First the num_sin_series sine time series
followed by the num_cos_series cosine time series.
}
\description{
Sin-Cos data set generator. This function generates a set of sine and cosine
time series. This function is used as example of the package application.
}
