% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomp.r
\name{smoothrb}
\alias{smoothrb}
\title{\code{smoothrb} smoothes a time series robustly by using Huber's psi-function. 
The initialisation uses a moving median.}
\usage{
smoothrb(y, beta = 0, q = NA)
}
\arguments{
\item{y}{the series, a vector or a time series}

\item{beta}{smoothing parameter (The larger beta is, the smoother will the smooth component g be.)}

\item{q}{length of running median which is used to get initial values}
}
\value{
g       vector,  the smooth component
}
\description{
\code{smoothrb} smoothes a time series robustly by using Huber's psi-function. 
The initialisation uses a moving median.
}
\examples{
data(GDP)
g  <- smoothrb(GDP,8,q=8)
\donttest{ 
 plot(GDP) ; t <- seq(from = 1970, to = 2009.5,by=0.25) ; lines(t,g,col="red") } 
}
