% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_span.R
\name{ts_span}
\alias{ts_span}
\title{Limit Time Span}
\usage{
ts_span(x, start = NULL, end = NULL, template = NULL, extend = FALSE)
}
\arguments{
\item{x}{ts-boxable time series, an object of class \code{ts}, \code{xts}, \code{zoo}, \code{data.frame}, \code{data.table}, \code{tbl}, \code{tbl_ts}, \code{tbl_time}, \code{tis}, \code{irts} or \code{timeSeries}.}

\item{start}{start date, character string, \code{Date} or \code{POSIXct}}

\item{end}{end date, character string, \code{Date} or \code{POSIXct}.}

\item{template}{ts-boxable time series, an object of class \code{ts}, \code{xts},
\code{data.frame}, \code{data.table}, or \code{tibble}. If provided, \code{from} and \code{to}
will be extracted from the object.}

\item{extend}{logical. If true, the start and end values are allowed to extend the series (by adding \code{NA} values).}
}
\value{
a ts-boxable time series, with the same class as the input.
}
\description{
Filter time series for a time span.
}
\details{
All date and times, when entered as character strings, are processed by
\code{anytime::anydate()} or \code{anytime::anytime()}. Thus a wide range of inputs are
possible. See examples.

\code{start} and \code{end} can be specified relative to each other,
using one of \code{"sec"}, \code{"min"}, \code{"hour"}, \code{"day"}, \code{"week"},
\code{"month"}, \verb{"quarter" or }"year", or an abbreviation. If the series are of the same frequency, the
shift can be specified in periods. See examples.
}
\examples{

\donttest{
# use 'anytime' shortcuts
ts_span(mdeaths, start = "1979")       # shortcut for 1979-01-01
ts_span(mdeaths, start = "1979-4")     # shortcut for 1979-04-01
ts_span(mdeaths, start = "197904")     # shortcut for 1979-04-01

# it's fine to use an to date outside of series span
ts_span(mdeaths, end = "2001-01-01")

# use strings to set start or end relative to each other

ts_span(mdeaths, start = "-7 month")   # last 7 months
ts_span(mdeaths, start = -7)           # last 7 periods
ts_span(mdeaths, start = -1)           # last single value
ts_span(mdeaths, end = "1e4 hours")    # first 10000 hours

ts_plot(
  ts_span(mdeaths, start = "-3 years"),
  title = "Three years ago",
  subtitle = "The last three years of available data"
)

ts_ggplot(
  ts_span(mdeaths, end = "28 weeks"),
  title = "28 weeks later",
  subtitle = "The first 28 weeks of available data"
) + theme_tsbox() + scale_color_tsbox()
}

# Limit span of 'discoveries' to the same span as 'AirPassengers'
ts_span(discoveries, template = AirPassengers)
ts_span(mdeaths, end = "19801201", extend = TRUE)
}
