% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.r, R/arbitration-methods.r,
%   R/dets-methods.r
\docType{methods}
\name{forecast}
\alias{forecast}
\alias{forecast,ADE-method}
\alias{forecast,DETS-method}
\title{Forecasting using an ensemble predictive model}
\usage{
forecast(object, h)

\S4method{forecast}{ADE}(object, h)

\S4method{forecast}{DETS}(object, h)
}
\arguments{
\item{object}{predictive model object. A \code{\link{ADE-class}}
or a \code{\link{DETS-class}} ensemble object;}

\item{h}{steps to forecast}
}
\description{
Generic function for forecasting
future values of a time series from an \code{\link{ADE-class}} model or a
\code{\link{DETS-class}} model.
}
\note{
the \code{forecast} generic in \strong{tsensembler} assumes that the
data is purely auto-regressive (no external variables), and that the target variable
is the first column of the data provided. For a different data setup, the
predict methods (\code{\link{predict}})
can be used (with successive calls with updates for multi-step forecasting).
}
\examples{
specs <- model_specs(
 learner = c("bm_svr", "bm_glm", "bm_mars"),
 learner_pars = NULL
)

data("water_consumption")
dataset <- embed_timeseries(water_consumption, 5)
train <- dataset[1:500, ]

model <- DETS(target ~., train, specs)
model2 <- ADE(target ~., train, specs, lambda = 30)

next_vals_dets <- forecast(model, h = 2)
next_vals_ade <- forecast(model2, h = 2)


}
\seealso{
\code{\link{predict}} for the predict method; \code{\link{update_weights}}
for updating the weights of a model after forecasting; \code{\link{update_base_models}}
for updating the base models of an ensemble.
}
\concept{forecasting using ensembles}
