/*
   MUIN2SER - compute the mutual information from two given time series
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <sgtty.h>
#ifdef aix
#include <unistd.h>
#endif
#define FNAMSIZ 55  /* define this to be your maximum file name size */

main(argc, argv)


    int argc;
    char **argv;

{
 struct  sgttyb otty;
 FILE    *source;
 extern  char *optarg;
 extern  int  optind;
#ifdef aix
 int     option;
#else
 char    option;
#endif
 int     i, j, have_pipe, npt, maxbit, ixmax, trace, nx, ny, nswap, len, xoffset, yoffset;
 int     *intx, *inty, *s, *q, *q_unsort, *indices_x, *indices_y, *position;
 double  *x, *y, *x0, *y0, freq, element[BUFSIZ];
 double  confidence;
 char    sfile[FNAMSIZ], name[BUFSIZ];
 char    usage[BUFSIZ], line[BUFSIZ], *ptr;
 strcpy  (usage, "usage: muin2ser [-m max.bit] [-c confidence level] \n                [-n #x-column,#y-column] [-trace]  filename");

 for (i=1; i < FNAMSIZ; i++) { sfile[i] = 0; }
 for (i=1; i < BUFSIZ;  i++) { name[i] = 0; }
 
 /* set the defaults */
 maxbit = 20;       /* default precision we handle is 20 bit */
 confidence = 0.2;  /* default confidence level */
 trace=0;           /* no tracing */
 nx = 1;            /* 1st column => x */
 ny = 2;            /* 2nd column => y */

 /* scan for arguments :*/
 for (i=1; i < argc; i++)
    {
     if (strcmp("-trace", argv[i]) == 0)
         strcpy(argv[i], "-T");
    }

 while ((option=getopt(argc, argv, "Tc:m:n:")) != -1)
   {
    switch (option) 
     {
      case 'T':
            trace=1;
            break;
      case 'c':
            confidence = atof(optarg);
            break;
      case 'm':
            maxbit = atoi(optarg);
            break;
      case 'n':
            nx = atoi(strtok(optarg, ","));
            if ((ptr=strtok(NULL,",")) != NULL)
               ny = atoi(ptr);
            if (nx > ny)    
              {
               nswap = ny;
               ny = nx;
               nx = nswap;
              }
            break;
      case '?':
            fprintf (stderr, "%s\n", usage);
            exit (2);
     }
   }

 /* check if we obtain our input from a pipe: */
 have_pipe = gtty(fileno(stdin), &otty);
 /* returns 0 if we have a pipe open, otherwise -1 */

 if (optind >= argc)
   {
    if (!have_pipe)
      {
       fprintf (stderr, "%s\n", usage);
       exit (2);
      }
    else
       source = stdin;
   }
 else
   {
    strcpy (sfile, argv[optind]);
    if ((source = fopen(sfile, "r")) == NULL)  /* check if file exists */
      {
       perror (sfile);   /* complain about non-existing file */
       exit (1);
      }
   }


 /* now read the input: */
 fgets(line, sizeof(line), source);
 sscanf (line, "%s", &name[0]);
 fgets(line, sizeof(line), source);
 sscanf (line, "%d", &npt);
 fgets(line, sizeof(line), source);
 sscanf (line, "%lf", &freq);
 
 /* reserve the necessary memory: */
 x0 = x = (double *) calloc (npt, sizeof(double));
 y0 = y = (double *) calloc (npt, sizeof(double));

 if (x0 == NULL || y0 == NULL)
    {
     fprintf (stderr, "ERROR:  Not enough memory; reduce number of data.\n"); 
     exit (2);
    }

 i = 0;
 /* check out if we have enough columns: */
 if (fgets(line, sizeof(line), source) != NULL)
   {
    j = 1;
    xoffset = 0;
    yoffset = 0;
    ptr = line;
    while  ((sscanf (ptr, "%lf%n", &element[j], &len) == 1) && (j<=ny))
        {
         if (j < nx) xoffset = xoffset + len;
         if (j < ny) yoffset = yoffset + len;
         j++;     /* scan on */
         ptr += len;
        }
    if (j-1 < ny)
      {
       fprintf (stderr, "ERROR:  only %d columns of data\n", j-1);
       exit (2);
      }
    *x = element[nx];
    *y = element[ny];
    x++; y++; i++;
   }
 
 while ((fgets(line, sizeof(line), source) != NULL) && (i <= npt))
   {
    ptr = line+xoffset;
    sscanf (ptr, "%lf", x++);
    ptr = line+yoffset;
    sscanf (ptr, "%lf", y++);
    i++;
   }
 
 if (!have_pipe) fclose(source);

 if (npt > i)
    {
     fprintf (stderr, "WARNING:  only %d data points found\n", i);
     npt = i;
    }

 /* reserve the necessary memory: */
 intx = (int *) calloc (npt, sizeof(int));
 inty = (int *) calloc (npt, sizeof(int));
 s = (int *) calloc (npt, sizeof(int));
 q = (int *) calloc (npt, sizeof(int));
 q_unsort = (int *) calloc (npt, sizeof(int));
 indices_x = (int *) calloc (npt, sizeof(int));
 indices_y = (int *) calloc (npt, sizeof(int));
#if defined(ultrix) || defined(hpux) || defined(aix)
 ixmax = (int) pow (2.0, (double) maxbit);
#else
 ixmax = (int) exp2 ((double) maxbit);
#endif
 position = (int *) calloc (ixmax+1, sizeof(int));

 if (intx == NULL || inty == NULL || s == NULL || q == NULL || q_unsort == NULL || indices_x == NULL || indices_y == NULL)
    {
     fprintf (stderr, "ERROR:  Not enough memory; reduce number of data.\n"); 
     exit (2);
    }
 if (position == NULL)
    {
     fprintf (stderr, "ERROR:  Not enough memory; reduce maximum resolution.\n"); 
     exit (2);
    }

#if defined(hpux) || defined(aix)
 muin2ser (&name[0], &npt, &freq, x0, y0, intx, inty, s, q, q_unsort, indices_x, indices_y, position, &maxbit, &confidence, &trace);
#else
 muin2ser_(&name[0], &npt, &freq, x0, y0, intx, inty, s, q, q_unsort, indices_x, indices_y, position, &maxbit, &confidence, &trace);
#endif
}
