% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.R
\name{fill_gaps}
\alias{fill_gaps}
\title{Turn implicit missing values into explicit missing values}
\usage{
fill_gaps(.data, ..., .full = FALSE, .start = NULL, .end = NULL)
}
\arguments{
\item{.data}{A tsibble.}

\item{...}{A set of name-value pairs. The values provided will only replace
missing values that were marked as "implicit", and will leave previously
existing \code{NA} untouched.
\itemize{
\item empty: filled with default \code{NA}.
\item filled by values or functions.
}}

\item{.full}{\itemize{
\item \code{FALSE} inserts \code{NA} for each keyed unit within its own period.
\item \code{TRUE} fills \code{NA} over the entire time span of the data (a.k.a. fully balanced panel).
\item \code{start()} pad \code{NA} to the same starting point (i.e. \verb{min(<index>)}) across units.
\item \code{end()} pad \code{NA} to the same ending point (i.e. \verb{max(<index>)}) across units.
}}

\item{.start, .end}{Set custom starting/ending time that allows to expand the
existing time spans.}
}
\description{
\lifecycle{stable}
}
\examples{
harvest <- tsibble(
  year = c(2010, 2011, 2013, 2011, 2012, 2014),
  fruit = rep(c("kiwi", "cherry"), each = 3),
  kilo = sample(1:10, size = 6),
  key = fruit, index = year
)

# gaps as default `NA`
fill_gaps(harvest, .full = TRUE)
fill_gaps(harvest, .full = start())
fill_gaps(harvest, .full = end())
fill_gaps(harvest, .start = 2009, .end = 2016)
full_harvest <- fill_gaps(harvest, .full = FALSE)
full_harvest

# replace gaps with a specific value
harvest \%>\%
  fill_gaps(kilo = 0L)

# replace gaps using a function by variable
harvest \%>\%
  fill_gaps(kilo = sum(kilo))

# replace gaps using a function for each group
harvest \%>\%
  group_by_key() \%>\%
  fill_gaps(kilo = sum(kilo))

# leaves existing `NA` untouched
harvest[2, 3] <- NA
harvest \%>\%
  group_by_key() \%>\%
  fill_gaps(kilo = sum(kilo, na.rm = TRUE))

# replace NA
pedestrian \%>\%
  group_by_key() \%>\%
  fill_gaps(Count = as.integer(median(Count)))

if (!requireNamespace("tidyr", quietly = TRUE)) {
  stop("Please install the 'tidyr' package to run these following examples.")
}
# use fill() to fill `NA` by previous/next entry
pedestrian \%>\%
  group_by_key() \%>\%
  fill_gaps() \%>\%
  tidyr::fill(Count, .direction = "down")
}
\seealso{
\link[tidyr:fill]{tidyr::fill}, \link[tidyr:replace_na]{tidyr::replace_na} for handling missing values \code{NA}.

Other implicit gaps handling: 
\code{\link{count_gaps}()},
\code{\link{has_gaps}()},
\code{\link{scan_gaps}()}
}
\concept{implicit gaps handling}
