% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m_unconstrain_search.R
\name{unconstrain.search}
\alias{unconstrain.search}
\title{MDL Based MOTIF Discovery for Multidimensional Matrix Profile}
\usage{
unconstrain.search(data, window.size, matrix.profile, profile.index,
  n.bit = 4, k = Inf)
}
\arguments{
\item{data}{a \code{matrix} of \code{numeric}, where each colums is a time series. Accepts \code{vector} (see details), \code{list} and \code{data.frame} too.}

\item{window.size}{an \code{int} with the size of the sliding window.}

\item{matrix.profile}{multidimensional matrix profile (from \code{\link[=mstomp]{mstomp()}} or \code{\link[=mstomp.par]{mstomp.par()}}).}

\item{profile.index}{multidimensional profile index (from \code{\link[=mstomp]{mstomp()}} or \code{\link[=mstomp.par]{mstomp.par()}}).}

\item{n.bit}{an \code{int}. Number of bits for MDL discretization. (Default is \code{4}).}

\item{k}{an \code{int}. The number of MOTIFs to retrieve. \code{Inf} means all possible MOTIFs. (Default is \code{Inf}).}
}
\value{
Returns the \code{motif.idx} with the index of MOTIFs founded and \code{motif.dim}
with the spanned dimensions of respective MOTIF.
}
\description{
MDL Based MOTIF Discovery for Multidimensional Matrix Profile.
}
\details{
Although this functions handles Multivariate Time Series, it can also be used to handle Univariate Time Series.
}
\examples{
# This is a fast toy example and results are useless. For a complete result, run the code inside
#'Not run' section below.
w <- toy_data$sub.len
mp <- mstomp(toy_data$data[1:200,], w, verbose = 0)
motifs <- unconstrain.search(toy_data$data[1:200,], w, mp$mp, mp$pi, 2)
\dontrun{
w <- toy_data$sub.len
mp <- mstomp.par(toy_data$data, w)
motifs <- unconstrain.search(toy_data$data, w, mp$mp, mp$pi, 4, 2)
}

}
\references{
\enumerate{
\item Yeh CM, Kavantzas N, Keogh E. Matrix Profile VI : Meaningful Multidimensional Motif Discovery.
}

\enumerate{
\item Zhu Y, Imamura M, Nikovski D, Keogh E. Matrix Profile VII: Time Series Chains: A New Primitive for Time Series Data Mining. Knowl Inf Syst. 2018 Jun 2;1–27.
}

Website: \url{https://sites.google.com/view/mstamp/}

Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
\seealso{
\code{\link[=mstomp]{mstomp()}}, \code{\link[=mstomp.par]{mstomp.par()}}, \code{\link[=guide.search]{guide.search()}}

Other mstomp: \code{\link{guide.search}},
  \code{\link{mstomp.par}}, \code{\link{mstomp}}
}
\concept{mstomp}
