% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xyz.R
\name{xyz}
\alias{xyz}
\title{XYZ analysis}
\usage{
xyz(x, m = NULL, prc = c(0.2, 0.3, 0.5), type = c("naive", "ets",
  "cv"))
}
\arguments{
\item{x}{this can either be an array, where each column is a series, or a vector of values. If \code{x} is a vector of values forecastability is not calculated and the input is used as such.}

\item{m}{seasonal length for time series. Required when type is \code{"naive"} or \code{"ets"}.}

\item{prc}{a vector of percentages indicating how many items are included in each class. By default this is \code{c(0.2,0.3,0.5)}, but any set of percentage values can be used as long as \code{0<=prc[i]<=1} and \code{sum(prc)==1}.}

\item{type}{the type of forecastability calculation. This can be:
\itemize{
\item{\code{"naive"}}{: fit naive and seasonal naive and calculate forecastability using RMSE/mean level.}
\item{\code{"ets"}}{: fit ets and calculate and calculate forecastability using RMSE/mean level.}
\item{\code{"cv"}}{: use coefficient of variation as a proxy of forecastability.}
}}
}
\value{
Return object of class \code{abc} and contains:
\itemize{
\item{\code{value}}{: a vector containing the forecastability value of each series.}
\item{\code{class}}{: a vector containing the class membership of each series.}
\item{\code{rank}}{: a vector containing the rank of each series, with 1 being the lowest forecastability series.}
\item{\code{conc}}{: the forecastability concentration of each class, as percentage of total value.}
\item{\code{model}}{: fitted model for each series.}
}
}
\description{
Perform XYZ analysis on a set of time series.
}
\examples{
x <- abs(matrix(cumsum(rnorm(5400,0,1)),36,150))
z <- xyz(x,m=12)
print(z)
plot(z)

}
\references{
Ord K., Fildes R., Kourentzes N. (2017) \href{http://kourentzes.com/forecasting/2017/10/16/new-forecasting-book-principles-of-business-forecasting-2e/}{Principles of Business Forecasting, 2e}. \emph{Wessex Press Publishing Co.}, p.515-518.
}
\seealso{
\code{\link{abc}}, \code{\link{plot.abc}}, \code{\link{abcxyz}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}.
}
\keyword{ts}
