% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{collect_predictions}
\alias{collect_predictions}
\alias{collect_predictions.default}
\alias{collect_predictions.tune_results}
\alias{collect_metrics}
\alias{collect_metrics.tune_results}
\alias{collect_metrics.tune_race}
\title{Obtain and format results produced by tuning functions}
\usage{
collect_predictions(x, ...)

\method{collect_predictions}{default}(x, ...)

\method{collect_predictions}{tune_results}(x, summarize = FALSE, parameters = NULL, ...)

collect_metrics(x, ...)

\method{collect_metrics}{tune_results}(x, summarize = TRUE, ...)

\method{collect_metrics}{tune_race}(x, summarize = TRUE, ...)
}
\arguments{
\item{x}{The results of \code{\link[=tune_grid]{tune_grid()}}, \code{\link[=tune_bayes]{tune_bayes()}}, \code{\link[=fit_resamples]{fit_resamples()}},
or \code{\link[=last_fit]{last_fit()}}. For \code{\link[=collect_predictions]{collect_predictions()}}, the control option \code{save_pred = TRUE} should have been used.}

\item{...}{Not currently used.}

\item{summarize}{A logical; should metrics be summarized over resamples
(\code{TRUE}) or return the values for each individual resample. Note that, if \code{x}
is created by \code{\link[=last_fit]{last_fit()}}, \code{summarize} has no effect. For the other object
types, the method of summarizing predictions is detailed below.}

\item{parameters}{An optional tibble of tuning parameter values that can be
used to filter the predicted values before processing. This tibble should
only have columns for each tuning parameter identifier (e.g. \code{"my_param"}
if \code{tune("my_param")} was used).}
}
\value{
A tibble. The column names depend on the results and the mode of the
model.

For \code{\link[=collect_metrics]{collect_metrics()}} and \code{\link[=collect_predictions]{collect_predictions()}}, when unsummarized,
there are columns for each tuning parameter (using the \code{id} from \code{\link[=tune]{tune()}},
if any).
\code{\link[=collect_metrics]{collect_metrics()}} also has columns \code{.metric}, and \code{.estimator}.  When the
results are summarized, there are columns for \code{mean}, \code{n}, and \code{std_err}.
When not summarized, the additional columns for the resampling identifier(s)
and \code{.estimate}.

For \code{\link[=collect_predictions]{collect_predictions()}}, there are additional columns for the resampling
identifier(s), columns for the predicted values (e.g., \code{.pred},
\code{.pred_class}, etc.), and a column for the outcome(s) using the original
column name(s) in the data.

\code{\link[=collect_predictions]{collect_predictions()}} can summarize the various results over
replicate out-of-sample predictions. For example, when using the bootstrap,
each row in the original training set has multiple holdout predictions
(across assessment sets). To convert these results to a format where every
training set same has a single predicted value, the results are averaged
over replicate predictions.

For regression cases, the numeric predictions are simply averaged. For
classification models, the problem is more complex. When class probabilities
are used, these are averaged and then re-normalized to make sure that they
add to one. If hard class predictions also exist in the data, then these are
determined from the summarized probability estimates (so that they match).
If only hard class predictions are in the results, then the mode is used to
summarize.
}
\description{
Obtain and format results produced by tuning functions
}
\examples{
\donttest{
data("example_ames_knn")
# The parameters for the model:
parameters(ames_wflow)

# Summarized over resamples
collect_metrics(ames_grid_search)

# Per-resample values
collect_metrics(ames_grid_search, summarize = FALSE)


# ---------------------------------------------------------------------------

library(parsnip)
library(rsample)
library(dplyr)
library(recipes)
library(tibble)

lm_mod <-linear_reg() \%>\% set_engine("lm")
set.seed(93599150)
car_folds <- vfold_cv(mtcars, v = 2, repeats = 3)
ctrl <- control_resamples(save_pred = TRUE)

spline_rec <-
  recipe(mpg ~ ., data = mtcars) \%>\%
  step_ns(disp, deg_free = tune("df"))

grid <- tibble(df = 3:6)

resampled <-
lm_mod \%>\%
tune_grid(spline_rec, resamples = car_folds, control = ctrl, grid = grid)

collect_predictions(resampled) \%>\% arrange(.row)
collect_predictions(resampled, summarize = TRUE) \%>\% arrange(.row)
collect_predictions(resampled, summarize = TRUE, grid[1,]) \%>\% arrange(.row)
}
}
