% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/last_fit.R
\name{last_fit}
\alias{last_fit}
\alias{last_fit.model_spec}
\alias{last_fit.workflow}
\title{Fit the final best model to the training set and evaluate the test set}
\usage{
last_fit(object, ...)

\method{last_fit}{model_spec}(
  object,
  preprocessor,
  split,
  ...,
  metrics = NULL,
  control = control_last_fit()
)

\method{last_fit}{workflow}(object, split, ..., metrics = NULL, control = control_last_fit())
}
\arguments{
\item{object}{A \code{parsnip} model specification or a \code{\link[workflows:workflow]{workflows::workflow()}}.
No tuning parameters are allowed.}

\item{...}{Currently unused.}

\item{preprocessor}{A traditional model formula or a recipe created using
\code{\link[recipes:recipe]{recipes::recipe()}}.}

\item{split}{An \code{rsplit} object created from \code{\link[rsample:initial_split]{rsample::initial_split()}}.}

\item{metrics}{A \code{\link[yardstick:metric_set]{yardstick::metric_set()}}, or \code{NULL} to compute a standard
set of metrics.}

\item{control}{A \code{\link[=control_last_fit]{control_last_fit()}} object used to fine tune the last fit
process.}
}
\value{
A single row tibble that emulates the structure of \code{fit_resamples()}.
However, a list column called \code{.workflow} is also attached with the fitted
model (and recipe, if any) that used the training set.
}
\description{
\code{\link[=last_fit]{last_fit()}} emulates the process where, after determining the best model,
the final fit on the entire training set is needed and is then evaluated on
the test set.
}
\details{
This function is intended to be used after fitting a \emph{variety of models}
and the final tuning parameters (if any) have been finalized. The next step
would be to fit using the entire training set and verify performance using
the test data.
}
\examples{
\donttest{
library(recipes)
library(rsample)
library(parsnip)

set.seed(6735)
tr_te_split <- initial_split(mtcars)

spline_rec <- recipe(mpg ~ ., data = mtcars) \%>\%
  step_ns(disp)

lin_mod <- linear_reg() \%>\%
  set_engine("lm")

spline_res <- last_fit(lin_mod, spline_rec, split = tr_te_split)
spline_res

# test set results
spline_res$.metrics[[1]]

# or use a workflow

library(workflows)
spline_wfl <-
  workflow() \%>\%
  add_recipe(spline_rec) \%>\%
  add_model(lin_mod)

last_fit(spline_wfl, split = tr_te_split)
}
}
