% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_membership.R
\name{check_membership}
\alias{check_membership}
\title{Check Membership in List of Tibbles}
\usage{
check_membership(tibble_list, key_var, membership, verbose = FALSE)
}
\arguments{
\item{tibble_list}{A named list of tibbles, each containing an "id" column and an "answer" column}

\item{key_var}{A character string specifying the key variable to check}

\item{membership}{A character vector of allowed values for the key variable}

\item{verbose}{Logical indicating whether to report removed items (default: FALSE)}
}
\value{
A list of tibbles where the key variable exists and its value is in the membership list
}
\description{
This function filters a list of tibbles based on whether a key variable's value
is among the membership values. It first uses check_key_vars() to ensure the
key variable exists, then checks membership. Useful for keeping only specific
students or participants.
}
\examples{
\dontrun{
# Create sample data with student emails
path <- file.path(find.package("tutorial.helpers"), "tests/testthat/fixtures/answers_html")

tibble_list <- gather_submissions(path, "stop")

result <- check_membership(tibble_list, 
                           key_var = "email", 
                           membership = c("bluebird.jack.xu@gmail.com", 
                                          "hassan.alisoni007@gmail.com"))

}
}
