% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvGLS.R
\name{tvGLS}
\alias{tvGLS}
\alias{tvGLS.list}
\alias{tvGLS.tvsure}
\title{Time-Varying Generalised Least Squares}
\usage{
tvGLS(x, ...)

\method{tvGLS}{list}(x, y, z = NULL, ez = NULL, bw, Sigma = NULL,
  R = NULL, r = NULL, est = c("lc", "ll"), tkernel = c("Epa",
  "Gaussian"), ...)

\method{tvGLS}{tvsure}(x, ...)
}
\arguments{
\item{x}{an object used to select a method.}

\item{...}{Other arguments passed to specific methods.}

\item{y}{A matrix.}

\item{z}{A vector with the smoothing variable.}

\item{ez}{(optional) A scalar or vector with the smoothing values. If 
values are included then the vector z is used.}

\item{bw}{A numeric vector.}

\item{Sigma}{An array.}

\item{R}{A matrix.}

\item{r}{A numeric vector.}

\item{est}{Either "lc" or "ll".}

\item{tkernel}{Either "Gaussian" or "Epa".}
}
\value{
\code{tvGLS} returns a list containing:
\item{tvcoef}{An array of dimension obs x nvar x neq (obs = number of observations, nvar = number of variables
in each equation, neq = number of equations in the system) with the time-varying coefficients estimates.}
\item{fitted}{A matrix of dimension obs x neq with the fited values from the estimation.}
\item{residuals}{A matrix of dimension obs x neq with the residuals from the estimation.}
}
\description{
\code{tvGLS} estimates time-varying coefficients of SURE using the kernel smoothing GLS.

\code{tvGLS} is used to estimate time-varying coefficients SURE using the kernel smoothing
generalised least square.
}
\details{
The classical GLS estimator must be modified to generate a set of coefficients changing over time.
The \code{tvGLS} finds a GLS estimate at a given point in time \emph{t} using the data near by.
The size of the data window used is given by the bandwidth. The closest a point is to \emph{t},
the larger is its effect on the estimation which is given by the kernel. In this programme,
the two possible kernels are the Epanechnikov and Gaussian. As in the classical GLS, the covariance
matrix is involved in the estimation formula. If this matrix is NULL or the identity, then the
programme returns the OLS estimates for time-varying coefficients.

Note, that unless with the tvSURE, the tvGLS may run with one common bandwidth for all
equations or with a different bandwidths for each equation.
}
\examples{
data(FF5F)
x <- list()
## SMALL/LoBM porfolios time-varying three factor model
x[[1]] <- cbind(rep (1, 314), FF5F[, c("NA.Mkt.RF", "NA.SMB",  "NA.HML", "NA.RMW", "NA.CMA")])
x[[2]] <- cbind(rep (1, 314), FF5F[, c("JP.Mkt.RF", "JP.SMB",  "JP.HML", "JP.RMW", "JP.CMA")])
x[[3]] <- cbind(rep (1, 314), FF5F[, c("AP.Mkt.RF", "AP.SMB",  "AP.HML", "AP.RMW", "AP.CMA")])
x[[4]] <- cbind(rep (1, 314), FF5F[, c("EU.Mkt.RF", "EU.SMB",  "EU.HML", "EU.RMW", "EU.CMA")])
##Returns
y <- cbind(FF5F$NA.SMALL.LoBM, FF5F$JP.SMALL.LoBM, FF5F$AP.SMALL.LoBM, 
FF5F$EU.SMALL.LoBM) 
##Excess returns
y <- y - cbind(FF5F$NA.RF, FF5F$JP.RF, FF5F$AP.RF, FF5F$EU.RF)
##I fit the data with one bandwidth for each equation
ff5f.fit <- tvGLS(x = x, y = y, bw = c(1.03, 0.44, 0.69, 0.31))

}
