% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvPsi.R
\name{tvPsi}
\alias{tvPsi}
\title{Time-Varying Coefficient Arrays of the Orthogonalised MA Represention}
\usage{
tvPsi(x, nstep = 10, ortho.cov = "const", bw.cov = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{tvvar}, generated by tvVAR().}

\item{nstep}{An integer specifying the number of othogonalised moving error coefficient
matrices to be calculated for each time t.}

\item{ortho.cov}{A character either 'const' if the error cov matrix must be estimated by a constant
or 'tv' if it is estimated as a time-varying matrix. Default is 'const'.}

\item{bw.cov}{A scalar (optional) with the bandwidth to estimate the errors variance-covariance matrix.}

\item{...}{Other parameters passed to specific methods.}
}
\value{
A list with an array of dimensions (obs x neq x neq nstep + 1) holding the estimated
time varying coefficients of the moving average representation, and the bandwidth used to estimate
the covariance matrix (optional).
}
\description{
Returns the estimated orthogonalised time-varying coefficient arrays of the
moving average representation of a stable \code{tvvar} object obtained with function \code{tvVAR}.
}
