% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_tvem_example.R
\name{simulate_tvem_example}
\alias{simulate_tvem_example}
\title{simulate_tvem_example: Simulate a dataset for demonstrating the tvem function.}
\usage{
simulate_tvem_example(
  n_subjects = 300,
  max_time = 7,
  simulate_binary = FALSE,
  n_obs_possible = 141,
  prop_obs_observed = 0.3,
  sigma_x1 = 2,
  sigma_x2 = 2,
  truncate_for_realism = TRUE,
  round_digits = 3,
  x1_short_term_rho = 0.7,
  x2_short_term_rho = 0.7,
  sigma_y = 1.5,
  mu_x1_function = function(t) {     6 - 2 * sqrt(pmax(0, (t/7) - 0.2)) },
  mu_x2_function = function(t) {     3 + sqrt(pmax(0, (t/7) - 0.5)) },
  beta0_y_function = function(t) {     1 - 0.3 * sqrt(t/7) },
  beta1_y_function = function(t) {     0.5 * (t/7)^2 },
  beta2_y_function = function(t) {     rep(0.2, length(t)) },
  y_short_term_rho = 0.8
)
}
\arguments{
\item{n_subjects}{Number of subjects in dataset}

\item{max_time}{The time point at the end of the simulated time interval}

\item{simulate_binary}{Whether the simulated data should be binary}

\item{n_obs_possible}{Total number of possible measurement times per subject}

\item{prop_obs_observed}{Proportion of these that are actually observed}

\item{sigma_x1}{Standard deviation of covariate 1, assumed homoskedastic over time}

\item{sigma_x2}{Standard deviation of covariate 2, assumed homoskedastic over time}

\item{truncate_for_realism}{Whether to prevent simulated values from going below 0 or above 10, 
in order to imitate survey data; used only for normally distributed outcomes.
Set this to FALSE if you are running a simulation, in order to avoid losing coverage
due to departing from the parametric model.}

\item{round_digits}{Number of digits at which to round the generated data; used only for normally distributed outcomes}

\item{x1_short_term_rho}{Correlation between adjacent measurements of covariate 1}

\item{x2_short_term_rho}{Correlation between adjacent measurements of covariate 2}

\item{sigma_y}{Error standard deviation of y, only used if the outcomes are to be normal rather than binary}

\item{mu_x1_function}{Mean of covariate 1 as function of time}

\item{mu_x2_function}{Mean of covariate 2 as function of time}

\item{beta0_y_function}{TVEM intercept as function of time}

\item{beta1_y_function}{TVEM coefficient of covariate 1 as function of time}

\item{beta2_y_function}{TVEM coefficient of covariate 2 as function of time}

\item{y_short_term_rho}{Correlation between adjacent measurements of y, only used if it is normal and not binary}
}
\value{
A simulated dataset with the following variables:
\describe{
\item{subject_id}{Subject ID}
\item{time}{Observation time}
\item{x1}{First covariate}
\item{x2}{Second covariate}
\item{y}{Outcome variable}
}
}
\description{
By default, the data-generating model has a time-varying intercept,
and two time-varying covariates named x1 and x2. 
x1 has a time-varying effect and x2 has a time-invariant effect.
}
\examples{
set.seed(123)
the_data <- simulate_tvem_example(simulate_binary=TRUE)

}
\keyword{Statistics|datagen}
