% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_parksAndRec.R
\name{theme_parksAndRecLight}
\alias{theme_parksAndRecLight}
\title{Parks & Recreation "Light" theme}
\usage{
theme_parksAndRecLight(text.font = NULL, title.font = NULL,
  legend.font = NULL, title.size = 20, text.size = 16,
  subtitle.size = 14, axis.title.size = 14, axis.text.size = 12,
  legend.title.size = 14, legend.text.size = 12,
  title.color = "grey20", subtitle.color = "grey20",
  text.color = "grey20", axis.title.color = "grey20",
  axis.text.color = "grey20", legend.title.color = "grey20",
  legend.text.color = "grey20", legend.position = "bottom",
  ticks = FALSE)
}
\arguments{
\item{text.font}{text font, Default: NULL}

\item{title.font}{title font, Default: NULL}

\item{legend.font}{legend font, Default: NULL}

\item{title.size}{title font size, Default: 20}

\item{text.size}{text font size, Default: 16}

\item{subtitle.size}{subtitle font size, Default: 14}

\item{axis.title.size}{axis title font size, Default: 14}

\item{axis.text.size}{axis text font size, Default: 12}

\item{legend.title.size}{legend title font size, Default: 14}

\item{legend.text.size}{legend text font size, Default: 12}

\item{title.color}{title color, Default: "grey20"}

\item{subtitle.color}{subtitle.color, Default: "grey20"}

\item{text.color}{text color, Default: "grey20"}

\item{axis.title.color}{axis title color, Default: "grey20"}

\item{axis.text.color}{axis text color, Default: "grey20"}

\item{legend.title.color}{legend title color, Default: "grey20"}

\item{legend.text.color}{legend text color, Default: "grey20"}

\item{legend.position}{legend position, Default: "bottom"}

\item{ticks}{add axis ticks, Default: FALSE}
}
\description{
Parks & Recreation light theme, Recommended font: "Titillium Web"
}
\details{
Actual font: 'Champion HTF-Heavyweight'
}
\examples{
library(ggplot2)

ggplot(airquality, aes(x = Day, y = Temp,
     group = as.factor(Month), color = as.factor(Month))) +
     geom_point(size = 2.5) +
     scale_color_parksAndRec() +
     theme_parksAndRecLight()
}
\seealso{
[ggplot2::theme]
}
