% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{combine.twosamples}
\alias{combine.twosamples}
\title{Combine two objects of class \code{twosamples}}
\usage{
combine.twosamples(x, y, check.sample = T)
}
\arguments{
\item{x}{a twosamples object}

\item{y}{a different twosamples object from the same \verb{*_test} function run on the same data}

\item{check.sample}{check that the samples saved in each object are the same? (can be slow)}
}
\value{
a twosamples object that correctly re-calculates the p-value and determines all the other attributes
}
\description{
This function combines two \code{twosamples} objects -- concatenating bootstraps, recalculating pvalues, etc.
It only works if both objects were created with "keep.boots=T" This function is intended for one main purposes: combining parallized null calculations and then plotting those combined outputs.
}
\examples{
vec1 = rnorm(10)
vec2 = rnorm(10,1)
out1 = dts_test(vec1,vec2)
out2 = dts_test(vec1,vec2)
combined = combine.twosamples(out1,out2)
summary(out1)
summary(out2)
summary(combined)
plot(combined)
}
\seealso{
\link{twosamples_class}, \link{plot.twosamples}, \link{dts_test}
}
