% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.twoway.R
\name{as.data.frame.twoway}
\alias{as.data.frame.twoway}
\title{Convert a twoway object to a data frame
This function converts a \code{"twoway"} object to a \code{data.frame}}
\usage{
\method{as.data.frame}{twoway}(x, ...)
}
\arguments{
\item{x}{a \code{"twoway"} object}

\item{...}{other arguments, presently ignored}
}
\value{
a data.frame with \eqn{r \times c} rows corresponding to the input data table, and the following columns
\describe{
 \item{row}{row labels}
 \item{col}{column labels}
 \item{data}{the data value in the cell}
 \item{fit}{the fitted value, }
 \item{roweff}{the row effect}
 \item{coleff}{the column effect}
 \item{nonadd}{the 1 df for non-additivity value}
}
}
\description{
The rows and columns of the data table are strung out in standard R order in a vector, joined with row and column labels.
Additional columns are added, representing the calculated values used in the two-way display.
}
\examples{
data(sentRT)
sent.2way <- twoway(sentRT)
as.data.frame(sent.2way)

}
