% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoway.formula.R
\name{twoway.formula}
\alias{twoway.formula}
\title{Formula method for twoway analysis using a dataset in long format}
\usage{
\method{twoway}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{formula}{A formula of the form \code{response ~ rowvar + colvar}, where \code{response} is numeric}

\item{data}{The name of the data set, containing a row vector, column factor and a numeric response}

\item{subset}{An expression to subset the data (unused)}

\item{na.action}{What to do with NAs? (unused)}

\item{...}{other arguments, passed down}
}
\description{
The formula method reshapes the data set from long to wide format and calls the default method.
}
\examples{
longRT <- to_long(taskRT)
twoway(RT ~ Task + Topic, data=longRT)
}
\references{
the conversion of long to wide in a formula method was suggested on
       \url{https://stackoverflow.com/questions/50469320/how-to-write-a-formula-method-that-converts-long-to-wide}
}
\author{
Michael Friendly and Richard Heiberger
}
