% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{confint.txshift}
\alias{confint.txshift}
\title{Confidence Intervals for Counterfactual Mean Under Stochastic Intervention}
\usage{
\method{confint}{txshift}(object, parm = seq_len(object$psi), level = 0.95, ..., ci_mult = NULL)
}
\arguments{
\item{object}{An object of class \code{txshift}, as produced by invoking
the function \code{\link{txshift}}, for which a confidence interval is to
be computed.}

\item{parm}{A \code{numeric} vector indicating indices of \code{object$est}
for which to return confidence intervals.}

\item{level}{A \code{numeric} indicating the level of the confidence
interval to be computed.}

\item{...}{Other arguments. Not currently used.}

\item{ci_mult}{Pre-computed multipliers for generating confidence intervals.
The default of \code{NULL} should generally NOT be changed and is only used
by the internal machinery for creating simultaneous confidence bands.}
}
\value{
A named \code{numeric} vector containing the parameter estimate from
 a \code{txshift} object, alongside lower and upper Wald-style confidence
 intervals at a specified coverage level.
}
\description{
Confidence Intervals for Counterfactual Mean Under Stochastic Intervention
}
\details{
Compute confidence intervals for estimates produced by
 \code{\link{txshift}}.
}
\examples{
set.seed(429153)
n_obs <- 100
W <- replicate(2, rbinom(n_obs, 1, 0.5))
A <- rnorm(n_obs, mean = 2 * W, sd = 1)
Y <- rbinom(n_obs, 1, plogis(A + W + rnorm(n_obs, mean = 0, sd = 1)))
txout <- txshift(
  W = W, A = A, Y = Y, delta = 0.5,
  estimator = "tmle",
  g_exp_fit_args = list(
    fit_type = "hal", n_bins = 5,
    grid_type = "equal_mass",
    lambda_seq = exp(-1:-9)
  ),
  Q_fit_args = list(
    fit_type = "glm",
    glm_formula = "Y ~ ."
  )
)
confint(txout)
}
