% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{clipmask-class}
\alias{clipmask-class}
\title{Class holding info for the clipper}
\value{
An S4 object of class "clipmask" to be used (internally) by the \code{\link{clipper}} function.
}
\description{
The filters we used to support our samples under the uFTIR microscope are round. This means that a cube might not be the best representation of our data, as they have noisy borders that might be missinterpreted by the program. Then, I implemented a \code{\link{clipper}} function to clip objects of class \code{\link[=SAM-class]{SAM}} or \code{\link[=Smooth-class]{Smooth}} (even an S3 matrix) before summarizing them. Although this can be done step by step, you can also create a clip-mask for the \code{\link{summary_sam}} function to clip them for you. To crate this clip-mask, you can call the function \code{\link{toClip}} which returns an object of this class.

The class has yet another use. Since the samples are placed under the microscope by hand, the cropping area is not always the same and (usually) it has to be adjusted. To have a visual aid, you can use the function \code{\link{toClip}}, to then plot a \code{\link[=SAM-class]{SAM}} or \code{\link[=Smooth-class]{Smooth}} and overlay the croppling circle by calling \code{\link[graphics]{polygon}} and the xycoords slot of an object of this class (returned by \code{\link{toClip}}). Using that process you can test manually different center points and radius for the clipping circle.
}
\section{Slots}{

\describe{
\item{\code{xycoords}}{polygon (circle) coodinates to plot. matrix with two columns (x,y).}

\item{\code{rad}}{cicle radius. integer.}

\item{\code{centre}}{circle centre. Numeric vector of two elements (x,y).}
}}

\examples{
NULL
}
\seealso{
\code{\link{toClip}} \code{\link{clipper}}
}
