% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argumentChecks.R
\name{isStationary_int}
\alias{isStationary_int}
\alias{isIdentifiable}
\title{Check the stationary and identification conditions of specified GMAR or StMAR model.}
\usage{
isStationary_int(p, M, params, restricted = FALSE)

isIdentifiable(p, M, params, restricted = FALSE, StMAR = FALSE,
  GStMAR = FALSE)
}
\arguments{
\item{p}{a positive integer specifying the order of AR coefficients.}

\item{M}{a positive integer specifying the number of mixture components. Except for G-StMAR model a size (2x1) vector specifying the number of GMAR-components M1 in
the first element and StMAR-components M2 in the second - then the total number of components is M=M1+M2.}

\item{params}{a real valued parameter vector specifying the model.
\describe{
  \item{For \strong{non-restricted} models:}{
    \describe{
      \item{For \strong{GMAR} model:}{Size \eqn{(M(p+3)-1x1)} vector \strong{\eqn{\theta}}\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
        \eqn{\alpha_{1},...,\alpha_{M-1}}), where \strong{\eqn{\upsilon_{m}}}\eqn{=(\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,
        \sigma_{m}^2)} and \strong{\eqn{\phi_{m}}}=\eqn{(\phi_{m,1},...,\phi_{m,p}), m=1,...,M}.}
      \item{For \strong{StMAR} model:}{Size \eqn{(M(p+4)-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
        \eqn{\alpha_{1},...,\alpha_{M-1}, \nu_{1},...,\nu_{M}}).}
    }
  }
  \item{For \strong{restricted} models:}{
    \describe{
      \item{For \strong{GMAR} model:}{Size \eqn{(3M+p-1x1)} vector \strong{\eqn{\theta}}\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
        \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1})}, where \strong{\eqn{\phi}}=\eqn{(\phi_{1},...,\phi_{M})}.}
      \item{For \strong{StMAR} model:}{Size \eqn{(4M+p-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
        \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1}, \nu_{1},...,\nu_{M})}.}
    }
  }
}
Symbol \eqn{\phi} denotes an AR coefficient, \eqn{\sigma^2} a variance, \eqn{\alpha} a mixing weight and \eqn{v} a degrees of
freedom parameter.
Note that in the case \strong{M=1} the parameter \eqn{\alpha} is dropped, and in the case of \strong{StMAR} model
the degrees of freedom parameters \eqn{\nu_{m}} have to be larger than \eqn{2}.}

\item{restricted}{an (optional) logical argument stating whether the AR coefficients \eqn{\phi_{m,1},...,\phi_{m,p}} are restricted
to be the same for all regimes. Default is \code{FALSE}.}

\item{StMAR}{an (optional) logical argument stating whether StMAR model should be considered instead of GMAR model. Default is \code{FALSE}.}

\item{GStMAR}{an (optional) logical argument stating whether G-StMAR model should be considered instead of GMAR model. In G-StMAR model the first M1 components
are GMAR-type and the rest M2 components are StMAR-type. Default is \code{FALSE}.}
}
\value{
Returns \code{TRUE} or \code{FALSE} accordingly.
}
\description{
FOR INTERNAL USE. \code{isStationary_int} checks the stationary condition and \code{isIdentifiable} checks the identification conditions
 of the specified GMAR or StMAR model.
}
\details{
These functions don't support models parametrized with general linear constraints.
}
\section{Warning}{

 These functions don't have any argument checks!
}

\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. (2015) Gaussian Mixture Autoregressive model for univariate time series.
         \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item References regarding the StMAR and G-StMAR models will be updated when they are published.
 }
}
