% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R, R/printMethods.R,
%   R/quantileResidualTests.R
\name{plot.qrtest}
\alias{plot.qrtest}
\alias{print.qrtest}
\alias{quantileResidualTests}
\title{Quantile residual tests for GMAR, StMAR , and G-StMAR models}
\usage{
\method{plot}{qrtest}(x, ...)

\method{print}{qrtest}(x, ..., digits = 3)

quantileResidualTests(
  gsmar,
  lagsAC = c(1, 2, 5, 10),
  lagsCH = lagsAC,
  nsimu = 1,
  printRes = TRUE
)
}
\arguments{
\item{x}{object of class \code{'qrtest'} created with the function \code{quantileResidualTests}.}

\item{...}{graphical parameters passed to \code{segments} in \code{plot.qrtest}.
Currectly not used in \code{print.qrtest}}

\item{digits}{the number of digits to be print}

\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{lagsAC}{a numeric vector of positive integers specifying the lags for which autocorrelation is tested.}

\item{lagsCH}{a numeric vector of positive integers specifying the lags for which conditional heteroscedasticity
is tested.}

\item{nsimu}{a positive integer specifying to how many simulated observations the covariance matrix Omega
(see Kalliovirta (2012)) should be based on. If smaller than data size, then omega will be based on the
given data and not on simulated data. Having the covariance matrix omega based on a large simulated sample
might improve the tests size properties.}

\item{printRes}{a logical argument defining whether the results should be printed or not.}
}
\value{
Returns an object of class \code{'qrtest'} containing the test results in data frames. In the cases
  of autocorrelation and conditional heteroscedasticity tests, the returned object also contains the
  associated individual statistics and their standard errors, discussed in \emph{Kalliovirta (2012)} at
  the pages 369-370.
}
\description{
\code{quantileResidualTests} performs quantile residual tests for GMAR, StMAR,
 and G-StMAR models, testing normality, autocorrelation, and conditional heteroscedasticity
 of the quantile residuals.
}
\details{
For a correctly specified GSMAR model employing the maximum likelihood estimator, the quantile residuals
  are asymptotically independent with standard normal distribution. They can hence be used in a similar
  manner to conventional Pearson's residuals. For more details about quantile residual based diagnostics,
  and in particular, about the quantile residual tests, see the cited article by \emph{Kalliovirta (2012)}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: Plot p-values of the autocorrelation and conditional
heteroskedasticity tests.

\item \code{print}: Print method for class 'qrtest' objects
}}

\section{Suggested packages}{

  Install the suggested package "gsl" for faster evaluations in the cases of StMAR and G-StMAR models.
  For large StMAR and G-StMAR models with large data, the evaluations may take significantly long time
  without the package "gsl".
}

\examples{
\donttest{
# GMAR model
fit12 <- fitGSMAR(simudata, p=1, M=2, model="GMAR")
qrt <- quantileResidualTests(fit12, lagsAC=c(1, 5, 10, 15))

# G-StMAR model
fit42g <- fitGSMAR(T10Y1Y, 4, M=c(1, 1), model="G-StMAR")
qrtest42g <- quantileResidualTests(fit42g)
plot(qrtest42g)

# Restricted GMAR model
fit43gmr <- fitGSMAR(T10Y1Y, 4, 3, model="GMAR", restricted=TRUE)
qrtest43gmr <- quantileResidualTests(fit43gmr, lagsAC=1:10)
plot(qrtest43gmr)

# Non-mixture version of StMAR model
fit101t <- fitGSMAR(T10Y1Y, 10, 1, model="StMAR", ncores=1, ncalls=1)
quantileResidualTests(fit101t, lagsAC=c(1, 2, 5), printRes=FALSE)

# Two-regime GMAR p=2 model with the second AR coeffiecient of
# of the second regime contrained to zero.
constraints <- list(diag(1, ncol=2, nrow=2), as.matrix(c(1, 0)))
fit22c <- fitGSMAR(T10Y1Y, 2, 2, constraints=constraints)
quantileResidualTests(fit22c, lagsAC=c(1, 3), printRes=FALSE)
}
}
\references{
\itemize{
   \item Galbraith, R., Galbraith, J. 1974. On the inverses of some patterned matrices arising
           in the theory of stationary time series. \emph{Journal of Applied Probability} \strong{11}, 63-71.
   \item Kalliovirta L. (2012) Misspecification tests based on quantile residuals.
           \emph{The Econometrics Journal}, \strong{15}, 358-393.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item Virolainen S. 2020. A mixture autoregressive model based on Gaussian and Student's t-distribution.	arXiv:2003.05221 [econ.EM].
 }
}
\seealso{
\code{\link{profile_logliks}}, \code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{diagnosticPlot}},
 \code{\link{predict.gsmar}}, \code{\link{getOmega}},
}
