% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncondMoments.R
\name{get_regime_autocovs}
\alias{get_regime_autocovs}
\title{Calculate regime specific autocovariances \strong{\eqn{\gamma}}\eqn{_{m,p}}}
\usage{
get_regime_autocovs(gsmar)
}
\arguments{
\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}
}
\value{
Returns a size \eqn{(pxM)} matrix containing the first p autocovariances of the components processes:
 i:th autocovariance in the i:th row and m:th component process in the m:th column.
}
\description{
\code{get_regime_autocovs} calculates the first p regime specific autocovariances \strong{\eqn{\gamma}}\eqn{_{m,p}}
  for the given GMAR, StMAR, or G-StMAR model.
}
\examples{
# GMAR model
params13 <- c(1.4, 0.88, 0.26, 2.46, 0.82, 0.74, 5.0, 0.68, 5.2, 0.72, 0.2)
gmar13 <- GSMAR(p=1, M=3, params=params13, model="GMAR")
get_regime_autocovs(gmar13)

# StMAR model
params12t <- c(1.38, 0.88, 0.27, 3.8, 0.74, 3.15, 0.8, 100, 3.6)
stmar12t <- GSMAR(p=1, M=2, params=params12t, model="StMAR")
get_regime_autocovs(stmar12t)

# G-StMAR model (similar to the StMAR model above)
params12gs <- c(1.38, 0.88, 0.27, 3.8, 0.74, 3.15, 0.8, 3.6)
gstmar12 <- GSMAR(p=1, M=c(1, 1), params=params12gs, model="G-StMAR")
get_regime_autocovs(gstmar12)
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. forthcoming. A mixture autoregressive model based on Student's t-distribution.
         \emph{Communications in Statistics - Theory and Methods}, doi: 10.1080/03610926.2021.1916531
   \item Virolainen S. 2020. A mixture autoregressive model based on Gaussian and Student's t-distributions. arXiv:2003.05221 [econ.EM].
   \item Lütkepohl H. 2005. New Introduction to Multiple Time Series Analysis. \emph{Springer}.
 }
}
\seealso{
Other moment functions: 
\code{\link{cond_moments}()},
\code{\link{get_regime_means}()},
\code{\link{get_regime_vars}()},
\code{\link{uncond_moments}()}
}
\concept{moment functions}
