% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_textures.R
\name{morpho_dem}
\alias{morpho_dem}
\title{calculates most important DEM parameters}
\usage{
morpho_dem(
  dem,
  item = c("hillshade", "slope", "aspect", "TRI", "TPI", "Roughness", "SLOPE", "ASPECT",
    "C_GENE", "C_PROF", "C_PLAN", " C_TANG", " C_LONG", "C_CROS", "C_MINI", "C_MAXI",
    "C_TOTA", "C_ROTO", "MTPI"),
  verbose = FALSE,
  morphoMethod = 6,
  minScale = 1,
  maxScale = 8,
  numScale = 2,
  retRaster = TRUE,
  gdalLinks = NULL,
  sagaLinks = NULL
)
}
\arguments{
\item{dem}{character filname to GeoTiff containing one channel DEM}

\item{item}{character list containing the keywords of the DEM parameter to be calculated. Default parameter are c("hillshade", "slope", "aspect", "TRI", "TPI", "Roughness", "SLOPE", "ASPECT", "C_GENE", "C_PROF", "C_PLAN", " C_TANG"," C_LONG", "C_CROS", "C_MINI", "C_MAXI", "C_TOTA", "C_ROTO", "MTPI")}

\item{verbose}{logical. be quiet}

\item{morphoMethod}{numeric. saga morphometric method  see also: \href{http://www.saga-gis.org/saga_tool_doc/6.2.0/ta_morphometry_0.html}{SAGA GIS Help}. GDAL parameters see also: \href{https://www.gdal.org/gdaldem.html}{gdaldem}}

\item{minScale}{numeric. in scale for multi scale TPI see also: \href{http://www.saga-gis.org/saga_tool_doc/6.2.0/ta_morphometry_28.html}{SAGA GIS Help}}

\item{maxScale}{numeric. max scale for multi scale TPI see also: \href{http://www.saga-gis.org/saga_tool_doc/6.2.0/ta_morphometry_28.html}{SAGA GIS Help}}

\item{numScale}{numeric. number of scale for multi scale TPI see also: \href{http://www.saga-gis.org/saga_tool_doc/6.2.0/ta_morphometry_28.html}{SAGA GIS Help}}

\item{retRaster}{boolean if TRUE a raster stack is returned}

\item{gdalLinks}{list. of GDAL tools cli pathes}

\item{sagaLinks}{list. of SAGA tools cli pathes}
}
\value{
raster* object
}
\description{
calculates most important DEM parameters
}
\note{
please provide a GeoTiff file
}
\examples{
\dontrun{
##- required packages
require(uavRst)
require(link2GI)
setwd(tempdir())
## check if OTB exists
gdal <- link2GI::linkGDAL()
saga <- link2GI::linkSAGA()
if (gdal$exist & saga$exist) {
data("mrbiko")
proj = "+proj=utm +zone=32 +datum=WGS84 +units=m +no_defs +ellps=WGS84 +towgs84=0,0,0"
mrbiko <- raster::projectRaster(mrbiko, crs = proj,method = "ngb",res = 20)
raster::writeRaster(mrbiko,"dem.tif",overwrite=TRUE)
r<-morpho_dem(dem="dem.tif",c("hillshade", "slope", "aspect", "TRI", "TPI",
                              "Roughness", "SLOPE", "ASPECT",  "C_GENE", "C_PROF",
                              "C_PLAN", " C_TANG"," C_LONG", "C_CROS"),
                              gdalLinks= gdal,sagaLinks=saga)
r_st=raster::stack(r)
names(r_st)=names(r)
raster::plot(r_st)
}
}
}
