% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_report_doc_set_ph}
\alias{system_report_doc_set_ph}
\title{Sets Placeholder Content for Word Document Report}
\usage{
system_report_doc_set_ph(cfg, rptname = "default", ph_name = NULL,
  ph_content = NULL, ph_location = "body")
}
\arguments{
\item{cfg}{ubiquity system object}

\item{rptname}{report name initialized with \code{system_report_init}}

\item{ph_name}{name of the placeholder}

\item{ph_content}{content to be replaced}

\item{ph_location}{location of the placeholder: \code{"body"} (default), \code{"header"}, or \code{"footer"}}
}
\value{
cfg ubiquity system object with the placeholder content set
}
\description{
Adds or updates content to be substituted for placeholders in the specified report.  

For example if you have <HEADER_LEFT> in the header of your document and you wanted to
replace it with the text "Upper left" you would do the following:

\code{
  cfg = system_report_doc_set_ph(cfg, 
        ph_content  = "Upper Left" ,
        ph_name     = "HEADER_LEFT", 
        ph_location = "header")}

Notice the \code{ph_name} just has \code{HEADER_LEFT} and leaves off the \code{<>}
}
