% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{sparql}
\alias{sparql}
\alias{prefix_query}
\title{Tools to create a custom SPARQL query}
\usage{
sparql(
  query,
  endpoint = "http://landregistry.data.gov.uk/landregistry/query",
  ...
)

prefix_query(query)
}
\arguments{
\item{query}{custom query.}

\item{endpoint}{land registry's web service endpoint.}

\item{...}{further arguments passed to \code{httr::GET}.}
}
\value{
Returns a tibble that has been parsed from json.
}
\description{
Function to create custom queries with the `/landregistry/query endpoint`. All
necessary prefixes have to be included and output will be parsed from json to
dataframe. The most prefixes from land registry can be include with \code{prefix_query}.
}
\examples{
custom_query <- "select * where {
  <http://landregistry.data.gov.uk/data/ukhpi/region/newport/month/2013-10> ?property ?value
}"
sparql(prefix_query(custom_query))

}
