% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crime-at-location.R
\name{ukc_crime_location}
\alias{ukc_crime_location}
\title{Crimes at a specific location}
\usage{
ukc_crime_location(lat, lng, location, date = NULL)
}
\arguments{
\item{lat}{Latitude. Accepts a single value.}

\item{lng}{Longitude. Accepts a single value.}

\item{location}{If specified, \code{lat} and \code{lng} are ignored. Location IDs are
available through other methods including \code{\link[=ukc_street_crime]{ukc_street_crime()}}.}

\item{date}{The year and month in "YYYY-MM" form. If \code{NULL}, latest
available month will be returned. Also accepts dates in formats that can be
coerced to \code{Date} class with \code{as.Date()}.}
}
\value{
A tibble with details of crimes at a given location.
}
\description{
Returns details at crimes at a given
}
\details{
If specified, \code{lat} and \code{lng} must be the same length. \code{location}
or both \code{lat} and \code{lng} must be specified.
}
\examples{
\dontrun{
x <- ukc_crime_location(lat = 52, lng = 0)

y <- ukc_crime_location(location = 802171)
}

}
