% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop-search-location.R
\name{ukc_stop_search_location}
\alias{ukc_stop_search_location}
\title{Stop and search}
\usage{
ukc_stop_search_location(lat, lng, location, date = NULL)
}
\arguments{
\item{lat}{Latitude. Accepts a single value or a vector of values to create
a custom polygon.}

\item{lng}{Longitude. Accepts a single value or a vector of values to create
a custom polygon.}

\item{location}{If specified, \code{lat} and \code{lng} are ignored. Location IDs are
available through other methods including \code{\link[=ukc_street_crime]{ukc_street_crime()}}.}

\item{date}{The year and month in "YYYY-MM" form. If \code{NULL}, latest
available month will be returned.}
}
\value{
A tibble with details of stop and searches outcomes.
}
\description{
Returns details on stops and searches at a given location. The stop and
searches returned in the API, like the crimes, are only an approximation
of where the actual stop and searches occurred, they are not the exact
locations.
}
\details{
If specified, \code{lat} and \code{lng} must be the same length. If only one
set of coordinates are given, all recorded stop and searches within a one
mile radius are returned. If multiple pairs, all recorded stop and searches
within a custom drawn polygon will be returned.
}
\examples{
\dontrun{
ukc_stop_search1 <- ukc_stop_search_location(lat = 52.629729, lng = -1.131592)

ukc_stop_search2 <- ukc_stop_search_location(
  lat = c(52.268, 53.194, 52.130),
  lng = c(0.543, 0.238, 0.478)
)
}

}
