% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{residuals.MxModel}
\alias{residuals.MxModel}
\title{Get residuals from an MxModel}
\usage{
\method{residuals}{MxModel}(object, digits = 2, suppress = NULL, ...)
}
\arguments{
\item{object}{An fitted \code{\link{mxModel}} from which to get residuals}

\item{digits}{rounding (default = 2)}

\item{suppress}{smallest deviation to print out (default = NULL = show all)}

\item{...}{Optional parameters}
}
\value{
- matrix of residuals
}
\description{
Return the \code{\link{residuals}} from an OpenMx RAM model
}
\examples{
require(OpenMx)
data(demoOneFactor)
latents  = c("g")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
	manifestVars = manifests, latentVars = latents,
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
residuals(m1)
residuals(m1, digits = 3)
residuals(m1, digits = 3, suppress = .005)
# residuals are returned as an invisible object you can capture in a variable
a = residuals(m1); a
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Reporting functions: \code{\link{RMSEA.MxModel}};
  \code{\link{RMSEA.summary.mxmodel}}; \code{\link{RMSEA}};
  \code{\link{coef.MxModel}};
  \code{\link{confint.MxModel}};
  \code{\link{extractAIC.MxModel}};
  \code{\link{logLik.MxModel}}; \code{\link{plot.MxModel}},
  \code{\link{umxPlot}}; \code{\link{plot}},
  \code{\link{plot.MxModel.ACE}}, \code{\link{umxPlotACE}};
  \code{\link{umxCI_boot}}; \code{\link{umxCI}};
  \code{\link{umxCompare}}; \code{\link{umxExpCov}};
  \code{\link{umxExpMeans}}; \code{\link{umxFitIndices}};
  \code{\link{umxStandardizeModel}};
  \code{\link{umxSummary.MxModel}};
  \code{\link{umx_drop_ok}}
}

