% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxDiagnose}
\alias{umxDiagnose}
\title{mxDiagnostic}
\usage{
umxDiagnose(model, tryHard = FALSE, diagonalizeExpCov = FALSE)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to diagnose}

\item{tryHard}{whether I should try and fix it? (defaults to FALSE)}

\item{diagonalizeExpCov}{Whether to diagonalize the ExpCov}
}
\value{
- helpful messages and perhaps a modified model
}
\description{
Diagnose problems in a model
}
\examples{
require(OpenMx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
myData = mxData(cov(demoOneFactor), type = "cov", numObs = 500)
m1 <- umxRAM("OneFactor", data = myData,
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1.0)
)
m1 = mxRun(m1)
umxSummary(m1, show = "std")
umxDiagnose(m1)
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}

