% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_lower2full}
\alias{umx_lower2full}
\title{umx_lower2full}
\usage{
umx_lower2full(lower.data, diag = FALSE, byrow = TRUE)
}
\arguments{
\item{lower.data}{An \code{\link{mxMatrix}}}

\item{diag}{A boolean noting whether the lower matrix includes the diagonal}

\item{byrow}{Whether the matrix is to be filled by row or by column}
}
\value{
- \code{\link{mxMatrix}}
}
\description{
Take a lower triangle of data (either from a "lower" \code{\link{mxMatrix}}, or as you might typed in a journal article)
and turn it into a full matrix.
}
\examples{
tmpn = c("ROccAsp", "REdAsp", "FOccAsp", "FEdAsp", "RParAsp",
         "RIQ", "RSES", "FSES", "FIQ", "FParAsp")
tmp = matrix(nrow = 10, ncol = 10, byrow = TRUE, dimnames = list(tmpn,tmpn), data =
	c(1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,  0.0000, 0.0000, 0,
	0.6247, 1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,  0.0000, 0.0000, 0,
	0.3269, 0.3669, 1.0000, 0.0000, 0.0000, 0.0000, 0.0000,  0.0000, 0.0000, 0,
	0.4216, 0.3275, 0.6404, 1.0000, 0.0000, 0.0000, 0.0000,  0.0000, 0.0000, 0,
	0.2137, 0.2742, 0.1124, 0.0839, 1.0000, 0.0000, 0.0000,  0.0000, 0.0000, 0,
	0.4105, 0.4043, 0.2903, 0.2598, 0.1839, 1.0000, 0.0000,  0.0000, 0.0000, 0,
	0.3240, 0.4047, 0.3054, 0.2786, 0.0489, 0.2220, 1.0000,  0.0000, 0.0000, 0,
	0.2930, 0.2407, 0.4105, 0.3607, 0.0186, 0.1861, 0.2707,  1.0000, 0.0000, 0,
	0.2995, 0.2863, 0.5191, 0.5007, 0.0782, 0.3355, 0.2302,  0.2950, 1.0000, 0,
	0.0760, 0.0702, 0.2784, 0.1988, 0.1147, 0.1021, 0.0931, -0.0438, 0.2087, 1)
)
umx_lower2full(tmp)
tmp = c(
	c(1.0000,
	0.6247, 1.0000,
	0.3269, 0.3669, 1.0000,
	0.4216, 0.3275, 0.6404, 1.0000,
	0.2137, 0.2742, 0.1124, 0.0839, 1.0000,
	0.4105, 0.4043, 0.2903, 0.2598, 0.1839, 1.0000,
	0.3240, 0.4047, 0.3054, 0.2786, 0.0489, 0.2220, 1.0000,
	0.2930, 0.2407, 0.4105, 0.3607, 0.0186, 0.1861, 0.2707,  1.0000,
	0.2995, 0.2863, 0.5191, 0.5007, 0.0782, 0.3355, 0.2302,  0.2950, 1.0000,
	0.0760, 0.0702, 0.2784, 0.1988, 0.1147, 0.1021, 0.0931, -0.0438, 0.2087, 1)
)
umx_lower2full(tmp)
tmp = c(
	c(0.6247,
	0.3269, 0.3669,
	0.4216, 0.3275, 0.6404,
	0.2137, 0.2742, 0.1124, 0.0839,
	0.4105, 0.4043, 0.2903, 0.2598, 0.1839,
	0.3240, 0.4047, 0.3054, 0.2786, 0.0489, 0.2220,
	0.2930, 0.2407, 0.4105, 0.3607, 0.0186, 0.1861, 0.2707,
	0.2995, 0.2863, 0.5191, 0.5007, 0.0782, 0.3355, 0.2302,  0.2950,
	0.0760, 0.0702, 0.2784, 0.1988, 0.1147, 0.1021, 0.0931, -0.0438, 0.2087)
)
umx_lower2full(tmp, diag = FALSE)
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other Miscellaneous Data Functions: \code{\link{umxHetCor}};
  \code{\link{umxPadAndPruneForDefVars}};
  \code{\link{umx_as_numeric}};
  \code{\link{umx_cont_2_ordinal}};
  \code{\link{umx_cov2raw}};
  \code{\link{umx_make_bin_cont_pair_data}};
  \code{\link{umx_merge_CIs}};
  \code{\link{umx_read_lower}};
  \code{\link{umx_residualize}}; \code{\link{umx_round}};
  \code{\link{umx_scale_wide_twin_data}};
  \code{\link{umx_scale}}; \code{\link{umx_swap_a_block}};
  \code{\link{umx}}, \code{\link{umx-package}}
}

