% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_paste_names}
\alias{umx_paste_names}
\title{umx_paste_names}
\usage{
umx_paste_names(varNames, textConstant = "", suffixes)
}
\arguments{
\item{varNames}{a list of base names, e.g c("bmi", "IQ")}

\item{textConstant}{The suffix added to all names, e.g. "_T" (default is "")}

\item{suffixes}{a list of terminal suffixes differentiating the var names (e.g c("1", "2"))}
}
\value{
- vector of suffixed var names, i.e., c("a_T1", "b_T1", "a_T2", "b_T2")
}
\description{
Helper to add suffixes to names: useful for expanding twin vars like "bmi" into c("bmi_T1", "bmi_T2")
Use textConstant to turning add a constant"E_T1", by adding "_T" and 1.
}
\examples{
umx_paste_names("bmi", "_T", 1:2)
umx_paste_names("bmi", suffixes = c("_T1", "_T2"))
varNames = umx_paste_names(c("N", "E", "O", "A", "C"), "_T", 1:2)
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Miscellaneous Utility Functions: \code{\link{qm}};
  \code{\link{umx_explode}}; \code{\link{umx_find_object}};
  \code{\link{umx_grep}}; \code{\link{umx_msg}};
  \code{\link{umx_names}}; \code{\link{umx_pb_note}};
  \code{\link{umx_print}}; \code{\link{umx_rename}};
  \code{\link{umx_rot}}; \code{\link{umx_trim}};
  \code{\link{umx}}, \code{\link{umx-package}}
}

