% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_round}
\alias{umx_round}
\title{umx_round}
\usage{
umx_round(df, digits = getOption("digits"), coerce = FALSE)
}
\arguments{
\item{df}{a dataframe to round in}

\item{digits}{how many digits to round to (defaults to getOption("digits"))}

\item{coerce}{whether to make the column numeric if it is not (default = FALSE)}
}
\value{
- \code{\link{mxModel}}
}
\description{
A version of round() which works on dataframes that contain non-numeric data (or data that cannot be coerced to numeric)
Helpful for dealing with table output that mixes numeric and string types.
}
\examples{
head(umx_round(mtcars, coerce = FALSE))
head(umx_round(mtcars, coerce = TRUE))
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxFactor}}, \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}},
  \code{\link{umx_cont_2_ordinal}},
  \code{\link{umx_cov2raw}}, \code{\link{umx_lower2full}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_merge_CIs}},
  \code{\link{umx_read_lower}}, \code{\link{umx_reorder}},
  \code{\link{umx_residualize}},
  \code{\link{umx_scale_wide_twin_data}},
  \code{\link{umx_scale}}, \code{\link{umx_swap_a_block}},
  \code{\link{umx}}
}

