% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxFitIndices}
\alias{umxFitIndices}
\title{umxFitIndices}
\usage{
umxFitIndices(model, refModels = mxRefModels(model, run = TRUE))
}
\arguments{
\item{model}{The \code{\link{mxModel}} for which you want fit indices.}

\item{refModels}{Independence and saturated models. default mxRefModels(model, run = TRUE)}
}
\value{
Table of fit statistics
}
\description{
A list of fit indices. Originated in this thread: http://openmx.psyc.virginia.edu/thread/765
note: This is not a full-fat fit reporter. It is not robust across multi-group designs,
definition variables. It is primarily designed to add less-often reported fit indices for 
RAM models where reviewer 2 wants something other than CFA/TLI/RMSEA :-).
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- umxRAM("One Factor",
	data = mxData(cov(demoOneFactor), type = "cov", numObs = 500),
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1)
)
umxFitIndices(m1)
# And with raw data
m1 <- umxRAM("m1", data = demoOneFactor,
	umxPath(latents, to = manifests),
	umxPath(v.m. = manifests),
	umxPath(v1m0 = latents)
)
umxFitIndices(m1)
umxAPA(umxFitIndices(m1), digits = 3)
}
\references{
-
}
\seealso{
Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{confint.MxModel}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{logLik.MxModel}}, \code{\link{plot.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxExpCov}},
  \code{\link{umxExpMeans}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotACE}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxE}}, \code{\link{umxPlotIP}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACE}}, \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}

