% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_make_TwinData}
\alias{umx_make_TwinData}
\title{umx_make_TwinData: Simulate twin data with control over A, C, E, and moderation}
\usage{
umx_make_TwinData(nMZpairs, nDZpairs = nMZpairs, a = c(avg = 0.5, min = 0,
  max = 1), c = NULL, e = NULL)
}
\arguments{
\item{nMZpairs}{Number of MZ pairs to simulate}

\item{nDZpairs}{Number of DZ pairs to simulate (if omitted defaults to nMZpairs)}

\item{a}{value for a, defaults to an example of moderation: c(avg=.5, min=0, max=1)}

\item{c}{value for c}

\item{e}{value for e}
}
\value{
- list of mzData and dzData data.frames
}
\description{
Makes MZ and DZ twin data, optionally moderated. Note, if you want a power calculator, see here:
\url{http://www.people.vcu.edu/~bverhulst/power/power.html}
}
\details{
You supply the number of pairs of each zygosity that wish to simulate (nMZpairs, nDZpairs), along with the values of a, c,and e.
a can take a list c(avg = .5, min = 0, max = 1). If specified will act like a moderated heritability, with average value avg, and swinging
down to min and up to max across 4-SDs of the moderator.
}
\examples{
str(umx_make_TwinData(nMZpairs = 100, nDZpairs = 100, a = .5, c = .3, e = .4))
str(umx_make_TwinData(nMZpairs = 100, nDZpairs = 100, a = .5, c = .3, e = .4))
str(umx_make_TwinData(nMZpairs = 100, a = c(avg = .5, min = 0, max = 1), c = .3, e = .4))
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
Other Twin Modeling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxACESexLim}}, \code{\link{umxACEcov}},
  \code{\link{umxACE}}, \code{\link{umxCF_SexLim}},
  \code{\link{umxCP}}, \code{\link{umxGxE_window}},
  \code{\link{umxGxE}}, \code{\link{umxIP}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxE}}, \code{\link{umxPlotIP}},
  \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umx}}
}

