% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxAPA}
\alias{umxAPA}
\alias{summaryAPA}
\title{umxAPA}
\usage{
umxAPA(obj, se = NULL, std = FALSE, digits = 2, use = "complete",
  min = 0.001, addComparison = NA, report = c("table", "html"),
  lower = TRUE)
}
\arguments{
\item{obj}{Either a model (\link{lm}), a beta-value, or a data.frame}

\item{se}{If b is a model, then name of the parameter of interest, else the SE (standard-error)}

\item{std}{If obj is an lm, whether to re-run the model on standardized data and report std betas}

\item{digits}{Round numbers to how many values}

\item{use}{If obj is a data.frame, how to handle NA (default = "complete")}

\item{min}{= .001 for a p-value, the smallest value to report numerically}

\item{addComparison}{for a p-value, whether to add "</=" default (NA) adds "<" if necessary}

\item{report}{what to return (default = markdown table). Use "html" to open a web page table}

\item{lower}{whether to report on the lower triangle of correlations for a data.frame (Default = TRUE)}
}
\value{
- string
}
\description{
This function creates object summaries used in reporting models, effects, and summarizing data.

1. Given an lm, will return a formated effect, including 95\% CI 
in square brackets, for one of the effects (specified by name in se). e.g.:
\code{\link{umxAPA}}(m1, "wt") yields:

\eqn{\beta} = -5.344 [-6.486, -4.203], p< 0.001

2. Given a dataframe, summaryAPA will return a table of correlations, with
the mean and SD of each variable as the last row. So, 
\code{umxAPA(mtcars[,c("cyl", "wt", "mpg", )])} yields a table of 
correlations, means and SDs thus:

\tabular{lccc}{
        \tab cyl         \tab  wt          \tab mpg          \cr
cyl     \tab 1           \tab  0.78        \tab -0.85        \cr
wt      \tab 0.78        \tab  1           \tab -0.87        \cr
mpg     \tab -0.85       \tab  -0.87       \tab 1            \cr
mean_sd \tab 6.19 (1.79) \tab  3.22 (0.98) \tab 20.09 (6.03)
}

3. Given obj and se, umxAPA returns a CI based on 1.96 times the se.

4. Given only a number as obj will be treated as a p-value as returned in APA format.
}
\examples{
# Generate a formatted string describing a regression:  
umxAPA(lm(mpg ~ wt + disp, mtcars))
umxAPA(lm(mpg ~ wt + disp, mtcars), "disp")
# Generate a summary table of correlations + Mean and SD:
umxAPA(mtcars[,1:3])
umxAPA(mtcars[,1:3], digits = 3)
umxAPA(mtcars[,1:3], lower = FALSE)
umxAPA(mtcars[,1:3], report = "html")
# Generate a CI string based on effect and se
umxAPA(.4, .3)
# format p-value
umxAPA(.0182613)
umxAPA(.000182613)
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{umxGetParameters}}, \code{\link{umxSummary}},
  \code{\link{umx_APA_pval}}, \code{\link{umx_aggregate}},
  \code{\link{umx_print}}, \code{\link{umx_show}},
  \code{\link{umx_time}}, \code{\link{umx}}
}
