% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxSummary.MxModel}
\alias{umxSummary.MxModel}
\title{Shows a compact, publication-style, summary of a RAM model}
\usage{
\method{umxSummary}{MxModel}(model, refModels = NULL,
  showEstimates = c("raw", "std", "none", "both"), digits = 2,
  report = c("markdown", "html"), filter = c("ALL", "NS", "SIG"),
  SE = TRUE, RMSEA_CI = FALSE, matrixAddresses = FALSE,
  std = "deprecated", ...)
}
\arguments{
\item{model}{The \code{\link{mxModel}} whose fit will be reported}

\item{refModels}{Saturated models if needed for fit indices (see example below:
If NULL will be competed on demand. If FALSE will not be computed. Only needed for raw data.}

\item{showEstimates}{What estimates to show. By default, the raw estimates are shown 
(Options = c("raw", "std", "none", "both").}

\item{digits}{How many decimal places to report (default = 2)}

\item{report}{If "html", then show results in browser (alternative = "markdown")}

\item{filter}{whether to show significant paths (SIG) or NS paths (NS) or all paths (ALL)}

\item{SE}{Whether to compute SEs... defaults to TRUE. In rare cases, you might need to turn off to avoid errors.}

\item{RMSEA_CI}{Whether to compute the CI on RMSEA (Defaults to FALSE)}

\item{matrixAddresses}{Whether to show "matrix address" columns (Default = FALSE)}

\item{std}{deprecated: use show = "std" instead!}

\item{...}{Other parameters to control model summary}
}
\value{
- parameterTable returned invisibly, if estimates requested
}
\description{
Report the fit of a model in a compact form suitable for a journal. Emits a "warning" 
when model fit is worse than accepted criterion (TLI >= .95 and RMSEA <= .06; (Hu & Bentler, 1999; Yu, 2002).
}
\details{
Note: For some (multi-group) models, you will need to fall back on \code{\link{summary}}

CIs and Identification
This function uses the standard errors reported by OpenMx to produce the CIs you see in umxSummary
These are used to derive confidence intervals based on the formula 95%CI = estimate +/- 1.96*SE)

Sometimes they appear NA. This often indicates a model which is not identified (see\url{http://davidakenny.net/cm/identify.htm}).
This can include empirical under-identification - for instance two factors
that are essentially identical in structure. use \code{\link{mxCheckIdentification}} to check identification.

One or more paths estimated at or close to zero suggests that fixing one or two of 
these to zero may fix the standard error calculation, 
and alleviate the need to estimate likelihood-based or bootstrap CIs

If factor loadings can flip sign and provide identical fit, this creates another form of 
under-identification and can break confidence interval estimation.
Fixing a factor loading to 1 and estimating factor variances can help here.
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- umxRAM("One Factor",
	data = mxData(cov(demoOneFactor), type = "cov", numObs = 500),
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1)
)
umxSummary(m1, showEstimates = "std")
# output as latex
umx_set_table_format("latex")
umxSummary(m1, showEstimates = "std")
umx_set_table_format("markdown")
# output as raw
umxSummary(m1, show = "raw")
m1 <- mxModel(m1,
  mxData(demoOneFactor[1:100,], type = "raw"),
  umxPath(mean = manifests),
  umxPath(mean = latents, fixedAt = 0)
)
m1 <- mxRun(m1)
umxSummary(m1, showEstimates = "std", filter = "NS")
}
\references{
- Hu, L., & Bentler, P. M. (1999). Cutoff criteria for fit indexes in covariance 
 structure analysis: Conventional criteria versus new alternatives. Structural Equation Modeling, 6, 1-55. 

 - Yu, C.Y. (2002). Evaluating cutoff criteria of model fit indices for latent variable models
 with binary and continuous outcomes. University of California, Los Angeles, Los Angeles.
 Retrieved from \url{http://www.statmodel.com/download/Yudissertation.pdf}

\url{http://tbates.github.io}
}
\seealso{
- \code{\link{umxRun}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxConfint}},
  \code{\link{umxExpCov}}, \code{\link{umxExpMeans}},
  \code{\link{umxFitIndices}}, \code{\link{umxPlotACEv}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}
