% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_names}
\alias{umx_names}
\alias{namez}
\title{umx_names}
\usage{
umx_names(df, pattern = ".*", replacement = NULL, ignore.case = TRUE,
  perl = FALSE, value = TRUE, fixed = FALSE, useBytes = FALSE,
  invert = FALSE, collapse = c("as.is", "as.vector", "as.formula"))
}
\arguments{
\item{df}{dataframe from which to get names.}

\item{pattern}{Used to find only matching names (supports grep/regular expressions)}

\item{replacement}{If not NULL, replaces the found string. Use backreferences ("\1" to "\9") to refer to (subexpressions).}

\item{ignore.case}{default = TRUE (opposite default to grep)}

\item{perl}{Should Perl-compatible regexps be used? Default = FALSE}

\item{value}{Return matching elements themselves (TRUE) or their indices (FALSE) default = TRUE (opposite default to grep)}

\item{fixed}{= FALSE (grep option If TRUE, pattern is a string to be matched as is. Overrides all conflicting arguments.)}

\item{useBytes}{= FALSE logical. grep option. If TRUE, matching is by byte rather than by character.}

\item{invert}{Return indices or values for elements that do not match (default = FALSE)}

\item{collapse}{"as.is" leaves alone. as.vector formats as pastable code, i.e., "c('a', 'b')", not "a"  "b" (default NULL), etc.}
}
\value{
\itemize{
\item vector of matches
}
}
\description{
Convenient equivalent of running \link{grep} on \link{names}, with value = TRUE and ignore.case = TRUE.

Plus:\code{umx_names} can handle dataframes, a model, model summary, or a vector of strings as input.

In these cases, it will search column names, parameter or summary output names, or
the literal string values themselves respectively.

In addition, \code{umx_names} can do \link[=grep]{replacement} of a found string (see exmples). It can also collapse the result (using \link{paste0})

\emph{Note}: \code{namez} (with a z) is a shortcut for \code{umx_names}, which makes it easy to replace where you'd otherwise use \link{names}.

You can learn more about the matching options (like inverting the selection etc.) in the help for base-R \link{grep}.
}
\examples{
umx_names(mtcars, "mpg") # only "mpg" matches this
#
# easy alias namez
namez(mtcars, "mpg") # vars beginning with 'd' = "disp", drat

# regular expressions
umx_names(mtcars, "r[ab]") # "drat", "carb"
namez(mtcars, "^d") # vars beginning with 'd' = "disp", drat
umx_names(mtcars, "mpg", replacement = "hello") # "mpg" replaced with "hello"

# Other options
umx_names(mtcars, "mpg", invert = TRUE) # non-matches (instead of matches)
umx_names(mtcars, "disp", value = FALSE) # Return indices of matches 
umx_names(mtcars, "^d" , fixed = TRUE)  # vars containing literal '^d' (none...)
namez(mtcars, "m", collapse = "as.vector") # paste-able R-code for a vector

# =======================================
# = Examples using built-in GFF dataset =
# =======================================

umx_names(GFF, "T_1$") # twin 1
# "zyg" "sex1" "age_T1" "gff_T1" "fc_T1" "qol_T1" "hap_T1"...
umx_names(GFF, "2$") # names ending in 2
umx_names(GFF, "[^12bs]$") # doesn't end in `1`, `2`, `b`, or `s`
# "zyg_6grp" "zyg_2grp" "divorce"
}
\references{
\itemize{
\item \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item Base-R pattern matching functions: \code{\link{grep}}.
And \code{\link{umx_check_names}} to check for existence of names in a dataframe.
}

Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{tmx_is.identified}}, \code{\link{umxAPA}},
  \code{\link{umxEval}}, \code{\link{umxFactorScores}},
  \code{\link{umxGetParameters}}, \code{\link{umxReduce}},
  \code{\link{umxSummary}}, \code{\link{umx_APA_model_CI}},
  \code{\link{umx_APA_pval}}, \code{\link{umx_aggregate}},
  \code{\link{umx_parameters}}, \code{\link{umx_print}},
  \code{\link{umx_show_fit_or_comparison}},
  \code{\link{umx_show}}, \code{\link{umx_time}},
  \code{\link{umx}}

Other String Functions: \code{\link{umx_explode_twin_names}},
  \code{\link{umx_explode}}, \code{\link{umx_grep}},
  \code{\link{umx_object_as_str}},
  \code{\link{umx_paste_names}}, \code{\link{umx_rot}},
  \code{\link{umx_trim}},
  \code{\link{umx_write_to_clipboard}}, \code{\link{umx}}
}
