% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxParameters}
\alias{umxParameters}
\alias{parameters}
\title{Display path estimates from a model, filtering by name and value.}
\usage{
umxParameters(
  x,
  thresh = c("all", "above", "below", "NS", "sig"),
  b = NULL,
  pattern = ".*",
  std = FALSE,
  digits = 2
)

parameters(
  x,
  thresh = c("all", "above", "below", "NS", "sig"),
  b = NULL,
  pattern = ".*",
  std = FALSE,
  digits = 2
)
}
\arguments{
\item{x}{an \code{\link[=mxModel]{mxModel()}} or model summary from which to report parameter estimates.}

\item{thresh}{optional: Filter out estimates 'below' or 'above' a certain value (default = "all").}

\item{b}{Combine with thresh to set a minimum or maximum for which estimates to show.}

\item{pattern}{Optional string to match in the parameter names. Default '.*' matches all. \code{\link[=regex]{regex()}} allowed!}

\item{std}{Standardize output: NOT IMPLEMENTED YET}

\item{digits}{Round to how many digits (2 = default).}
}
\value{
\itemize{
\item list of matching parameters, filtered by name and value
}
}
\description{
Often you want to see the estimates from a model, and often you don't want all of them.
\code{\link[=umxParameters]{umxParameters()}} helps in this case, allowing you to select parameters matching a name filter,
and also to only show parameters above or below a certain value.

If pattern is a vector, each regular expression is matched, and all unique matches to the whole vector are returned.
}
\details{
It is on my TODO list to implement filtering by significance, and to add standardizing.
}
\examples{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("One Factor", data = mxData(demoOneFactor, type = "raw"),
	umxPath(from = "G", to = manifests),
	umxPath(v.m. = manifests),
	umxPath(v1m0 = "G")
)
# Parameters with values below .1
umxParameters(m1, "below", .1)
# Parameters with values above .5
umxParameters(m1, "above", .5)
# Parameters with values below .1 and containing "_to_" in their label
umxParameters(m1, "below", .1, "_to_")
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=umxGetParameters]{umxGetParameters()}}, \code{\link[=umxSummary]{umxSummary()}}, \code{\link[=namez]{namez()}}
}

Other Reporting Functions: \code{\link{FishersMethod}()},
  \code{\link{loadings.MxModel}()},
  \code{\link{tmx_is.identified}()},
  \code{\link{tmx_show}()}, \code{\link{umxAPA}()},
  \code{\link{umxFactorScores}()},
  \code{\link{umxGetParameters}()},
  \code{\link{umxReduce}()},
  \code{\link{umxWeightedAIC}()},
  \code{\link{umx_APA_pval}()},
  \code{\link{umx_aggregate}()}, \code{\link{umx_names}()},
  \code{\link{umx_print}()}, \code{\link{umx_time}()},
  \code{\link{umx}}
}
\concept{Reporting Functions}
