% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_is_class}
\alias{umx_is_class}
\title{Check if variables in a dataframe are in a list of classes.}
\usage{
umx_is_class(df, classes = NULL, all = TRUE)
}
\arguments{
\item{df}{A dataframe to check}

\item{classes}{vector of valid classes, e.g. numeric}

\item{all}{Whether to return a single all() Boolean or each column individually.}
}
\value{
\itemize{
\item Boolean or Boolean vector
}
}
\description{
Checks the class of each column in a dataframe, seeing if they are \%in\% a list of classes.
Returns a vector of TRUE and FALSE, or, if all ==TRUE, a single binary (the default).
}
\examples{
umx_is_class(mtcars) # report class list
# Are the variables in mtcars type character?
umx_is_class(mtcars, "character") # FALSE
# They're all numeric data
umx_is_class(mtcars, "numeric") # TRUE
# Show the test-result for each variable in mtcars
umx_is_class(mtcars, "numeric") # TRUE
# Are they _either_ a char OR a num?
umx_is_class(mtcars, c("character", "numeric"))
# Is zygosity a factor (note we don't drop = F to keep as dataframe)
umx_is_class(twinData[,"zygosity", drop=FALSE], classes = "factor")
umx_is_class(mtcars$mpg) # report class of this column (same as class(mpg))
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=umx_is_numeric]{umx_is_numeric()}}
}

Other Check or test: 
\code{\link{umx_check_names}()},
\code{\link{umx_is_endogenous}()},
\code{\link{umx_is_exogenous}()},
\code{\link{umx_is_numeric}()},
\code{\link{umx_is_ordered}()},
\code{\link{umx}}
}
\concept{Check or test}
