% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxReduce}
\alias{umxReduce}
\title{Reduce models, and report the results.}
\usage{
umxReduce(
  model,
  report = c("markdown", "inline", "html"),
  intervals = TRUE,
  baseFileName = "tmp",
  tryHard = "yes",
  silent = FALSE,
  ...
)
}
\arguments{
\item{model}{The \code{\link[=mxModel]{mxModel()}} which will be reduced.}

\item{report}{How to report the results. "html" = open in browser}

\item{intervals}{Recompute CIs (if any included) on the best model (default = TRUE)}

\item{baseFileName}{(optional) custom filename for html output (defaults to "tmp")}

\item{tryHard}{Default = "yes"}

\item{silent}{Default = FALSE}

\item{...}{Other parameters to control model summary}
}
\description{
Given a \code{umx} model (currently \code{umxACE} and \code{umxGxE} are supported - ask for more!)
\code{umxReduce} will conduct a formalised reduction process. It will also report
Akaike weights are also reported showing relative support across models.

Specialized functions are called for different type of input:
\enumerate{
\item \strong{GxE model reduction} For \code{\link[=umxGxE]{umxGxE()}} models \code{\link[=umxReduceGxE]{umxReduceGxE()}} is called.
\item \strong{ACE model reduction} For \code{\link[=umxACE]{umxACE()}} models,\code{\link[=umxReduceACE]{umxReduceACE()}} is called.
}

\code{umxReduce} reports the results in a table. Set the format of the table with
\code{\link[=umx_set_table_format]{umx_set_table_format()}}, or set \code{report= "html"} to open a
table for pasting into a word processor.

\code{umxReduce} is a work in progress, with more automatic reductions coming as demand emerges.
I am thinking for RAM models to drop NS paths, and report that test.
}
\references{
\itemize{
\item Wagenmakers, E.J., & Farrell, S. (2004). AIC model selection using Akaike weights.
\emph{Psychonomic Bulletin and Review}, \strong{11}, 192-196. \doi{10.3758/BF03206482}
}
}
\seealso{
\code{\link[=umxReduceGxE]{umxReduceGxE()}}, \code{\link[=umxReduceACE]{umxReduceACE()}}

Other Model Summary and Comparison: 
\code{\link{umxCompare}()},
\code{\link{umxEquate}()},
\code{\link{umxMI}()},
\code{\link{umxSetParameters}()},
\code{\link{umxSummary}()},
\code{\link{umx}}

Other Twin Modeling Functions: 
\code{\link{power.ACE.test}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxACE}()},
\code{\link{umxCP}()},
\code{\link{umxDoCp}()},
\code{\link{umxDoC}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxGxE}()},
\code{\link{umxIP}()},
\code{\link{umxReduceACE}()},
\code{\link{umxReduceGxE}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umxSummarizeTwinData}()},
\code{\link{umxSummaryACEv}()},
\code{\link{umxSummaryACE}()},
\code{\link{umxSummaryDoC}()},
\code{\link{umxSummaryGxEbiv}()},
\code{\link{umxSummarySexLim}()},
\code{\link{umxSummarySimplex}()},
\code{\link{umxTwinMaker}()},
\code{\link{umx}}
}
\concept{Model Summary and Comparison}
\concept{Twin Modeling Functions}
